/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkClass;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkPlugin;
import dev.jeka.core.tool.builtins.java.JkPluginJava;
import dev.jeka.plugins.protobuf.JkProtobuf;
import java.nio.file.Path;
import java.util.Arrays;

@JkDoc(value={"Compiles protocol buffer files to java source."})
public class JkPluginProtobuf
extends JkPlugin {
    public static final JkModuleId PROTOBUF_MODULE = JkModuleId.of((String)"com.google.protobuf:protobuf-java");
    private static final String DEFAULT_OUT = "jeka/output/generated_sources/java";
    @JkDoc(value={"Relative path of the protocol buffer files."})
    public String protoFilePath = "src/main/proto";
    @JkDoc(value={"Location where .java files are generated."})
    public String outPath = "jeka/output/generated_sources/java";
    @JkDoc(value={"Extra arguments to add to 'protoc' command."})
    public String extraArgs = "";

    protected JkPluginProtobuf(JkClass jkClass) {
        super(jkClass);
    }

    @JkDoc(value={"Add protocol buffer source generation to the Java Project Maker. The source generation will be automatically run prior compilation phase."})
    protected void afterSetup() {
        if (this.javaPlugin() != null) {
            this.javaPlugin().getProject().getConstruction().getCompilation().getPreCompileActions().append(this::compileProtocolBufferFiles);
        }
    }

    @JkDoc(value={"Compiles protocol buffer files to java."})
    public void compileProtocolBufferFiles() {
        JkLog.startTask((String)("Compiling protocol buffer files from " + this.protoFilePath), (Object[])new Object[0]);
        JkPathTree jkPathTree = this.getJkClass().getBaseTree().goTo(this.protoFilePath);
        String[] stringArray = JkUtilsString.translateCommandline((String)this.extraArgs);
        Path path = this.javaPlugin() == null || !DEFAULT_OUT.equals(this.outPath) ? this.getJkClass().getBaseDir().resolve(this.outPath) : this.javaPlugin().getProject().getConstruction().getCompilation().getLayout().resolveGeneratedSourceDir();
        JkProtobuf.compile(jkPathTree, Arrays.asList(stringArray), path);
        JkLog.endTask();
    }

    private JkPluginJava javaPlugin() {
        if (this.getJkClass().getPlugins().hasLoaded(JkPluginJava.class)) {
            return (JkPluginJava)this.getJkClass().getPlugin(JkPluginJava.class);
        }
        return null;
    }
}

