/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import com.github.os72.protocjar.Protoc;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.plugins.protobuf.JkProtobufNativeWrapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;

public class JkProtobufJarWrapper {
    public static void compile(JkPathTree jkPathTree, List<String> list, Path path) {
        JkUtilsPath.createDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
        String[] stringArray = JkProtobufNativeWrapper.makeArgs(jkPathTree, jkPathTree.getRoot(), list, path);
        try {
            Protoc.runProtoc((String[])stringArray);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Error while running protoc with args " + stringArray, iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Error while running protoc with args " + Arrays.asList(stringArray), interruptedException);
        }
        JkLog.info((String)("Protocol buffer compiled " + jkPathTree.count(100000, false) + " files to " + path + "."), (Object[])new Object[0]);
    }
}

