/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkScope;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.project.JkJavaProjectJarProduction;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkCommandSet;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkPlugin;
import dev.jeka.core.tool.builtins.java.JkPluginJava;
import dev.jeka.plugins.protobuf.JkProtobufWrapper;
import java.nio.file.Path;
import java.util.Arrays;

@JkDoc(value={"Compiles protocol buffer files to javaPlugin source."})
public class JkPluginProtobuf
extends JkPlugin {
    private static final String DEFAULT_OUT = "jeka/output/generated_sources/java";
    @JkDoc(value={"Relative path of the protocol buffer files."})
    public String protoFilePath = "src/main/protobuf";
    @JkDoc(value={"Location where .java files are generated."})
    public String outPath = "jeka/output/generated_sources/java";
    @JkDoc(value={"Extra arguments to add to 'protoc' command."})
    public String extraArgs = "";
    @JkDoc(value={"The version of Protocol Buffer to add to the project compile classpath (only relevant id using JkPluginJava plugin."})
    public String javaProtocolBufferVersion = "3.8.0";

    protected JkPluginProtobuf(JkCommandSet jkCommandSet) {
        super(jkCommandSet);
    }

    protected String getLowestJekaCompatibleVersion() {
        return "0.9.0.M10";
    }

    @JkDoc(value={"Add protocol buffer source generation to the Java Project Maker. The source generation will be automatically run prior compilation phase."})
    protected void activate() {
        if (this.javaPlugin() != null) {
            ((JkJavaProjectJarProduction)this.javaPlugin().getProject().getJarProduction().getDependencyManagement().addDependencies((JkDependencySet)JkDependencySet.of((String)this.protobufModuleVersion(), (JkScope[])new JkScope[0])).__).getCompilation().getBeforeCompile().append(this::compileProtocolBufferFiles);
        }
    }

    @JkDoc(value={"Compiles protocol buffer files to java."})
    public void compileProtocolBufferFiles() {
        JkLog.startTask((String)("Compiling protocol buffer files from " + this.protoFilePath), (Object[])new Object[0]);
        JkPathTree jkPathTree = this.getCommandSet().getBaseTree().goTo(this.protoFilePath);
        String[] stringArray = JkUtilsString.translateCommandline((String)this.extraArgs);
        Path path = this.javaPlugin() == null || !DEFAULT_OUT.equals(this.outPath) ? this.getCommandSet().getBaseDir().resolve(this.outPath) : this.javaPlugin().getProject().getJarProduction().getCompilation().getLayout().resolveGeneratedSourceDir();
        JkProtobufWrapper.compile(jkPathTree, Arrays.asList(stringArray), path);
        JkLog.endTask();
    }

    private JkPluginJava javaPlugin() {
        if (this.getCommandSet().getPlugins().hasLoaded(JkPluginJava.class)) {
            return (JkPluginJava)this.getCommandSet().getPlugins().get(JkPluginJava.class);
        }
        return null;
    }

    private String protobufModuleVersion() {
        return "com.google.protobuf:protobuf-java:" + this.javaProtocolBufferVersion;
    }
}

