/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class JkProtobufWrapper {
    private static final String PROTOC_COMMAND = "protoc";

    public static void compile(JkPathTree jkPathTree, List<String> list, Path path) {
        JkUtilsPath.createDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
        JkProcess.of((String)PROTOC_COMMAND, (String[])JkProtobufWrapper.makeArgs(jkPathTree, jkPathTree.getRoot(), list, path)).withFailOnError(true).withLogCommand(JkLog.isVerbose()).runSync();
        JkLog.info((String)("Protocol buffer compiled " + jkPathTree.count(100000, false) + " files to " + path + "."), (Object[])new Object[0]);
    }

    private static String[] makeArgs(JkPathTree jkPathTree, Path path, List<String> list, Path path2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--proto_path=" + path.normalize().toString());
        arrayList.add("--java_out=" + path2.normalize().toString());
        for (Path path3 : jkPathTree.getFiles()) {
            arrayList.add(path3.normalize().toString());
        }
        arrayList.addAll(list);
        return arrayList.toArray(new String[0]);
    }
}

