/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectSourceGenerator;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.plugins.protobuf.JkProtocSourceGenerator;

public final class JkProtobuf {
    private String protoPath = "src/main/proto";
    private String protocVersion = "3.11.4";
    private String extraProtocOptions = "";
    private String protobufVersion = "3.21.12";

    private JkProtobuf() {
    }

    public static JkProtobuf of() {
        return new JkProtobuf();
    }

    public JkProtobuf setProtoPath(String protoPath) {
        this.protoPath = protoPath;
        return this;
    }

    public JkProtobuf setProtocVersion(@JkDepSuggest(versionOnly=true, hint="com.github.os72:protoc-jar") String protocVersion) {
        this.protocVersion = protocVersion;
        return this;
    }

    public JkProtobuf setExtraProtocOptions(String extraProtocOptions) {
        this.extraProtocOptions = extraProtocOptions;
        return this;
    }

    public JkProtobuf setProtobufVersion(@JkDepSuggest(versionOnly=true, hint="com.google.protobuf:protobuf-java:") String protobufVersion) {
        this.protobufVersion = protobufVersion;
        return this;
    }

    public void configure(JkProject project) {
        JkProtocSourceGenerator sourceGenerator = JkProtocSourceGenerator.of(project.dependencyResolver.getRepos(), this.protoPath).setExtraProtocOptions(this.extraProtocOptions).setProtocJarVersion(this.protocVersion);
        project.compilation.addSourceGenerator((JkProjectSourceGenerator)sourceGenerator);
        if (!JkUtilsString.isBlank((String)this.protobufVersion)) {
            project.compilation.dependencies.add("com.google.protobuf:protobuf-java:" + this.protobufVersion, new Object[0]);
        }
    }
}

