/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkCoordinateFileProxy;
import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class JkProtoc {
    public static final JkModuleId PROTOBUF_MODULE = JkModuleId.of((String)"com.google.protobuf:protobuf-java");
    private static final String PROTOC_JAR_MODULE = "com.github.os72:protoc-jar";
    public static final String PROTOC_JAR_VERSION = "3.11.4";
    private final List<String> protocOptions = new LinkedList<String>();
    private String protocJarVersion = "3.11.4";
    private boolean logCommand = true;
    private boolean logOutput;
    private JkRepoSet repos = JkRepo.ofMavenCentral().toSet();

    private JkProtoc() {
    }

    public static JkProtoc of() {
        return new JkProtoc();
    }

    public static JkProtoc ofJava(Path outputPath) {
        return JkProtoc.of().setJavaOutputDir(outputPath);
    }

    public void compile(JkPathTreeSet protoFiles, String ... extraOptions) {
        LinkedList<String> extraOps = new LinkedList<String>(Arrays.asList(extraOptions));
        protoFiles.getRootDirsOrZipFiles().forEach(dir -> extraOps.add("--proto_path=" + dir));
        this.compile(protoFiles.getRelativeFiles(), extraOps.toArray(new String[0]));
    }

    public void compile(List<Path> protoFiles, String ... extraOptions) {
        List<Path> outDirs = this.outDirs();
        JkUtilsAssert.state((!outDirs.isEmpty() ? 1 : 0) != 0, (String)"No output directory has been specified.", (Object[])new Object[0]);
        outDirs.forEach(dir -> JkUtilsPath.createDirectories((Path)dir, (FileAttribute[])new FileAttribute[0]));
        Path jar = JkCoordinateFileProxy.of((JkRepoSet)this.repos, (String)("com.github.os72:protoc-jar:" + this.protocJarVersion)).get();
        JkJavaProcess javaProcess = (JkJavaProcess)((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJavaJar((Path)jar, null).addParams(this.protocOptions)).addParams(extraOptions)).setLogCommand(this.logCommand)).setLogOutput(this.logOutput);
        for (Path file : protoFiles) {
            javaProcess.addParams(new String[]{file.toString()});
        }
        javaProcess.exec(new String[0]);
        JkLog.info((String)("Protocol buffer compiled " + protoFiles.size() + " files to " + outDirs + "."), (Object[])new Object[0]);
    }

    public JkProtoc setJavaOutputDir(Path path) {
        return this.addOptions("--java_out=" + path.normalize());
    }

    public JkProtoc addProtoPath(Path path) {
        return this.addOptions("--proto_path=" + path.normalize());
    }

    public JkProtoc addOptions(String ... options) {
        Arrays.stream(options).forEach(option -> this.protocOptions.add((String)option));
        return this;
    }

    public JkProtoc setRepos(JkRepoSet repos) {
        this.repos = repos;
        return this;
    }

    public JkProtoc setProtocJarVersion(@JkDepSuggest(versionOnly=true, hint="com.google.protobuf:protobuf-java:") String protocJarVersion) {
        this.protocJarVersion = protocJarVersion;
        return this;
    }

    public JkProtoc setLogCommand(boolean logCommand) {
        this.logCommand = logCommand;
        return this;
    }

    public JkProtoc setLogOutput(boolean logOutput) {
        this.logOutput = logOutput;
        return this;
    }

    private Optional<String> getOptionValue(String prefix) {
        return this.protocOptions.stream().filter(option -> option.startsWith(prefix)).map(option -> JkUtilsString.substringAfterFirst((String)option, (String)prefix)).findFirst();
    }

    private List<Path> outDirs() {
        LinkedList<Path> result = new LinkedList<Path>();
        this.getOptionValue("--java_out=").ifPresent(value -> result.add(Paths.get(value, new String[0])));
        this.getOptionValue("--python_out=").ifPresent(value -> result.add(Paths.get(value, new String[0])));
        this.getOptionValue("--cpp_out=").ifPresent(value -> result.add(Paths.get(value, new String[0])));
        return result;
    }
}

