/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkSourceGenerator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.plugins.protobuf.JkProtoc;
import java.nio.file.Path;

public class JkProtocSourceGenerator
extends JkSourceGenerator {
    private final String protoFilePath;
    private String extraProtocOptions = "";
    private JkRepoSet repos;
    private String protocJarVersion;

    private JkProtocSourceGenerator(JkRepoSet repos, String protoFilePath) {
        this.protoFilePath = protoFilePath;
        this.repos = repos;
    }

    public static JkProtocSourceGenerator of(JkRepoSet repos, String protoFilePath) {
        return new JkProtocSourceGenerator(repos, protoFilePath);
    }

    public static JkProtocSourceGenerator of(JkRepoSet repos) {
        return new JkProtocSourceGenerator(repos, "src/main/proto");
    }

    public JkProtocSourceGenerator setExtraProtocOptions(String extraOptions) {
        this.extraProtocOptions = extraOptions;
        return this;
    }

    public JkProtocSourceGenerator setRepos(JkRepoSet repos) {
        this.repos = repos;
        return this;
    }

    public JkProtocSourceGenerator setProtocJarVersion(String protocJarVersion) {
        this.protocJarVersion = protocJarVersion;
        return this;
    }

    public String getDirName() {
        return "protobuf";
    }

    public void generate(JkProject project, Path generatedSourceDir) {
        JkLog.startTask((String)("Compiling protocol buffer files from " + this.protoFilePath), (Object[])new Object[0]);
        JkPathTree protoFiles = JkPathTree.of((Path)project.getBaseDir()).goTo(this.protoFilePath);
        String[] extraOptions = JkUtilsString.translateCommandline((String)this.extraProtocOptions);
        JkProtoc protoc = JkProtoc.ofJava(generatedSourceDir).setRepos(this.repos).addOptions(extraOptions);
        if (!JkUtilsString.isBlank((String)this.protocJarVersion)) {
            protoc.setProtocJarVersion(this.protocJarVersion);
        }
        protoc.compile(protoFiles.toSet(), new String[0]);
        JkLog.endTask();
    }
}

