/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkSourceGenerator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.plugins.protobuf.JkProtoc;
import java.nio.file.Path;

public class JkProtocSourceGenerator
extends JkSourceGenerator {
    private final String protoFilePath;
    private String extraProtocOptions = "";
    private JkRepoSet repos;
    private String protocJarVersion;

    private JkProtocSourceGenerator(JkRepoSet jkRepoSet, String string) {
        this.protoFilePath = string;
        this.repos = jkRepoSet;
    }

    public static JkProtocSourceGenerator of(JkRepoSet jkRepoSet, String string) {
        return new JkProtocSourceGenerator(jkRepoSet, string);
    }

    public static JkProtocSourceGenerator of(JkRepoSet jkRepoSet) {
        return new JkProtocSourceGenerator(jkRepoSet, "src/main/proto");
    }

    public JkProtocSourceGenerator setExtraProtocOptions(String string) {
        this.extraProtocOptions = string;
        return this;
    }

    public JkProtocSourceGenerator setRepos(JkRepoSet jkRepoSet) {
        this.repos = jkRepoSet;
        return this;
    }

    public JkProtocSourceGenerator setProtocJarVersion(String string) {
        this.protocJarVersion = string;
        return this;
    }

    public String getDirName() {
        return "protobuf";
    }

    public void generate(JkProject jkProject, Path path) {
        JkLog.startTask((String)("Compiling protocol buffer files from " + this.protoFilePath), (Object[])new Object[0]);
        JkPathTree jkPathTree = JkPathTree.of((Path)jkProject.getBaseDir()).goTo(this.protoFilePath);
        String[] stringArray = JkUtilsString.translateCommandline((String)this.extraProtocOptions);
        JkProtoc jkProtoc = JkProtoc.ofJava(path).setRepos(this.repos).addOptions(stringArray);
        if (!JkUtilsString.isBlank((String)this.protocJarVersion)) {
            jkProtoc.setProtocJarVersion(this.protocJarVersion);
        }
        jkProtoc.compile(jkPathTree.toSet(), new String[0]);
        JkLog.endTask();
    }
}

