/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkSourceGenerator;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.protobuf.JkProtocSourceGenerator;

@JkDoc(value={"Provides configuration and methods to compile protoBuffers files."})
public class ProtobufJkBean
extends JkBean {
    @JkDoc(value={"The path (relative to project root) of directory containing the proto files."})
    public String protoPath = "src/main/proto";
    @JkDoc(value={"Version of protoc compiler. Should be a version of module 'com.github.os72:protoc-jar'"})
    public String protocVersion = "3.11.4";
    @JkDoc(value={"Extra options to pass to protoc compiler. See https://manpages.ubuntu.com/manpages/xenial/man1/protoc.1.html"})
    public String extraProtocOptions = "";
    @JkDoc(value={"The version of com.google.protobuf:protobuf-java to include in compile-time dependencies. If empty or null, this dependencies won't be included automatically. The version will be resolved against coordinate 'com.google.protobuf:protobuf-java'"})
    @JkDepSuggest(versionOnly=true, hint="com.google.protobuf:protobuf-java:")
    public String protobufVersion = "3.21.12";

    ProtobufJkBean() {
        ((ProjectJkBean)this.getBean(ProjectJkBean.class)).configure(this::configure);
    }

    private void configure(JkProject jkProject) {
        JkProtocSourceGenerator jkProtocSourceGenerator = JkProtocSourceGenerator.of(jkProject.dependencyResolver.getRepos(), this.protoPath).setExtraProtocOptions(this.extraProtocOptions).setProtocJarVersion(this.protocVersion);
        jkProject.compilation.addSourceGenerator((JkSourceGenerator)jkProtocSourceGenerator);
        if (!JkUtilsString.isBlank((String)this.protobufVersion)) {
            jkProject.compilation.configureDependencies(jkDependencySet -> jkDependencySet.and("com.google.protobuf:protobuf-java:" + this.protobufVersion));
        }
    }
}

