/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.protobuf;

import dev.jeka.core.api.depmanagement.JkCoordinateFileProxy;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class JkProtoc {
    public static final JkModuleId PROTOBUF_MODULE = JkModuleId.of((String)"com.google.protobuf:protobuf-java");
    private static final String PROTOC_JAR_MODULE = "com.github.os72:protoc-jar";
    public static final String PROTOC_JAR_VERSION = "3.11.4";
    private List<String> protocOptions = new LinkedList<String>();
    private String protocJarVersion = "3.11.4";
    private boolean logCommand = true;
    private boolean logOutput;
    private JkRepoSet repos = JkRepo.ofMavenCentral().toSet();

    private JkProtoc() {
    }

    public static JkProtoc of() {
        return new JkProtoc();
    }

    public static JkProtoc ofJava(Path path) {
        return JkProtoc.of().setJavaOutputDir(path);
    }

    public void compile(JkPathTreeSet jkPathTreeSet, String ... stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        jkPathTreeSet.getRootDirsOrZipFiles().forEach(path -> linkedList.add("--proto_path=" + path));
        this.compile(jkPathTreeSet.getRelativeFiles(), linkedList.toArray(new String[0]));
    }

    public void compile(List<Path> list, String ... stringArray) {
        List<Path> list2 = this.outDirs();
        JkUtilsAssert.state((!list2.isEmpty() ? 1 : 0) != 0, (String)"No output directory has been specified.", (Object[])new Object[0]);
        list2.forEach(path -> JkUtilsPath.createDirectories((Path)path, (FileAttribute[])new FileAttribute[0]));
        Path path2 = JkCoordinateFileProxy.of((JkRepoSet)this.repos, (String)("com.github.os72:protoc-jar:" + this.protocJarVersion)).get();
        JkJavaProcess jkJavaProcess = (JkJavaProcess)((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJavaJar((Path)path2, null).addParams(this.protocOptions)).addParams(stringArray)).setLogCommand(this.logCommand)).setLogOutput(this.logOutput);
        for (Path path3 : list) {
            jkJavaProcess.addParams(new String[]{path3.toString()});
        }
        jkJavaProcess.exec(new String[0]);
        JkLog.info((String)("Protocol buffer compiled " + list.size() + " files to " + list2 + "."), (Object[])new Object[0]);
    }

    public JkProtoc setJavaOutputDir(Path path) {
        return this.addOptions("--java_out=" + path.normalize());
    }

    public JkProtoc addProtoPath(Path path) {
        return this.addOptions("--proto_path=" + path.normalize());
    }

    public JkProtoc addOptions(String ... stringArray) {
        Arrays.stream(stringArray).forEach(string -> this.protocOptions.add((String)string));
        return this;
    }

    public JkProtoc setRepos(JkRepoSet jkRepoSet) {
        this.repos = jkRepoSet;
        return this;
    }

    public JkProtoc setProtocJarVersion(String string) {
        this.protocJarVersion = string;
        return this;
    }

    public JkProtoc setLogCommand(boolean bl) {
        this.logCommand = bl;
        return this;
    }

    public JkProtoc setLogOutput(boolean bl) {
        this.logOutput = bl;
        return this;
    }

    private Optional<String> getOptionValue(String string) {
        return this.protocOptions.stream().filter(string2 -> string2.startsWith(string)).map(string2 -> JkUtilsString.substringAfterFirst((String)string2, (String)string)).findFirst();
    }

    private List<Path> outDirs() {
        LinkedList<Path> linkedList = new LinkedList<Path>();
        this.getOptionValue("--java_out=").ifPresent(string -> linkedList.add(Paths.get(string, new String[0])));
        this.getOptionValue("--python_out=").ifPresent(string -> linkedList.add(Paths.get(string, new String[0])));
        this.getOptionValue("--cpp_out=").ifPresent(string -> linkedList.add(Paths.get(string, new String[0])));
        return linkedList;
    }
}

