/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.openapi;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.depmanagement.JkRepoProperties;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkSourceGenerator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.openapi.JkOpenApiGeneratorCli;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

@JkDoc(value={"Provides project configuration for generating code from openApi specifications."})
public class OpenapiJkBean
extends JkBean {
    @JkDoc(value={"The command line arguments in conjunction with 'exec' method."})
    public String cmdLine;
    @JkDoc(value={"Version of openapi-generator-cli to use."})
    @JkDepSuggest(versionOnly=true, hint="org.openapitools:openapi-generator:")
    public String cliVersion = "7.0.1";
    @JkDoc(value={"If true, the specified cmdLine will be run to generate sources at compile time"})
    public boolean autoGenerate = true;

    @JkDoc(value={"Execute openApi cli with argument specified in 'cmdArgs'."})
    public void exec() {
        this.exec(this.cmdLine);
    }

    @JkDoc(value={"Display generic help about openApi cli options"})
    public void cliHelp() {
        this.exec("help");
    }

    @JkDoc(value={"Display help about available for 'generate' options"})
    public void cliHelpGenerate() {
        this.exec("help generate");
    }

    @JkDoc(value={"Display the available generators"})
    public void cliList() {
        this.exec("list");
    }

    @JkDoc(value={"Display config-help for spring server"})
    public void cliConfigHelpSpring() {
        this.exec("config-help -g spring");
    }

    @JkDoc(value={"Display config-help for java client"})
    public void cliConfigHelpJavaClient() {
        this.exec("config-help -g java");
    }

    public OpenapiJkBean() {
        ProjectJkBean projectJkBean = (ProjectJkBean)this.getBean(ProjectJkBean.class);
        projectJkBean.lately(jkProject -> {
            if (this.autoGenerate) {
                for (String string : OpenapiJkBean.commands(this.getRuntime().getProperties())) {
                    jkProject.compilation.addSourceGenerator((JkSourceGenerator)new CmdLineGenerator(string));
                }
            }
        });
    }

    private int exec(String string) {
        JkRepoProperties jkRepoProperties = JkRepoProperties.of((JkProperties)this.getRuntime().getProperties());
        JkOpenApiGeneratorCli jkOpenApiGeneratorCli = JkOpenApiGeneratorCli.of(jkRepoProperties.getDownloadRepos(), this.cliVersion);
        return jkOpenApiGeneratorCli.execCmdLine(string);
    }

    private static List<String> commands(JkProperties jkProperties) {
        return new LinkedList<String>(jkProperties.getAllStartingWith("openapi.gen.", false).values());
    }

    private class CmdLineGenerator
    extends JkSourceGenerator {
        private final String command;

        protected String getDirName() {
            return "openapi";
        }

        protected void generate(JkProject jkProject, Path path) {
            JkOpenApiGeneratorCli jkOpenApiGeneratorCli = JkOpenApiGeneratorCli.of(jkProject.dependencyResolver.getRepos(), OpenapiJkBean.this.cliVersion);
            String string = this.command + " " + "--output" + " " + path;
            string = string + " " + "--additional-properties" + "=sourceFolder=/";
            string = string + " --global-property modelTests=false,apiTests=false";
            if (JkLog.isVerbose()) {
                string = string + " --verbose";
            }
            jkOpenApiGeneratorCli.execCmdLine(string);
        }

        public String toString() {
            return "OpenapiKBeanGenerator";
        }

        public CmdLineGenerator(String string) {
            this.command = string;
        }
    }
}

