/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.openapi;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class JkOpenapiCmdBuilder {
    public static final String INPUT_SPEC = "--input-spec";
    public static final String GENERATOR_NAME = "--generator-name";
    public static final String OUTPUT_PATH = "--output";
    public static final String MODEL_NAME_PREFIX = "--model-name-prefix";
    public static final String MODEL_NAME_SUFFIX = "--model-name-suffix";
    public static final String MODEL_PACKAGE = "--model-package";
    public static final String PACKAGE_NAME = "--package-name";
    public static final String INVOKER_PACKAGE = "--invoker-package";
    public static final String API_NAME_SUFFIX = "--api-name-suffix";
    public static final String API_PACKAGE = "--api-package";
    public static final String BASE_PACKAGE = "--base-package";
    public static final String ADDITIONAL_PROPERTIES = "--additional-properties";
    public static final String IMPORT_MAPPINGS = "--import-mappings";
    public static final String TYPE_MAPPINGS = "--type-mappings";
    public static final String GLOBAL_PROPERTY = "--global-property";
    private List<String> args = new LinkedList<String>();
    private StringBuilder additionalProperties = new StringBuilder();
    private StringBuilder globalProperties = new StringBuilder();
    private StringBuilder importMappings = new StringBuilder();
    private StringBuilder typeMappings = new StringBuilder();
    private boolean generateTests = false;

    public static JkOpenapiCmdBuilder of(String string, String string2) {
        JkOpenapiCmdBuilder jkOpenapiCmdBuilder = new JkOpenapiCmdBuilder();
        jkOpenapiCmdBuilder.add(GENERATOR_NAME, string);
        jkOpenapiCmdBuilder.add(INPUT_SPEC, string2);
        return jkOpenapiCmdBuilder;
    }

    public JkOpenapiCmdBuilder add(String ... stringArray) {
        Arrays.stream(stringArray).forEach(string -> this.args.add((String)string));
        return this;
    }

    public JkOpenapiCmdBuilder addApiAndModelPackage(String string) {
        return this.add(API_PACKAGE, string).add(MODEL_PACKAGE, string);
    }

    public JkOpenapiCmdBuilder addAdditionalProperties(String string, String string2) {
        if (this.additionalProperties.length() > 0) {
            this.additionalProperties.append(",");
        }
        this.additionalProperties.append(string).append("=").append(string2);
        return this;
    }

    public JkOpenapiCmdBuilder addGlobalProperties(String string, String string2) {
        if (this.globalProperties.length() > 0) {
            this.globalProperties.append(",");
        }
        this.globalProperties.append(string).append("=").append(string2);
        return this;
    }

    public JkOpenapiCmdBuilder addImportMapping(String string, String string2) {
        if (this.importMappings.length() > 0) {
            this.importMappings.append(",");
        }
        this.importMappings.append(string).append("=").append(string2);
        return this;
    }

    public JkOpenapiCmdBuilder addTypeMapping(String string, String string2) {
        if (this.typeMappings.length() > 0) {
            this.typeMappings.append(",");
        }
        this.typeMappings.append(string).append("=").append(string2);
        return this;
    }

    public List<String> build() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("generate");
        linkedList.addAll(this.args);
        if (this.additionalProperties.length() > 0) {
            linkedList.add("--additional-properties=" + this.additionalProperties);
        }
        if (this.globalProperties.length() > 0) {
            linkedList.add("--global-property=" + this.globalProperties);
        }
        if (this.importMappings.length() > 0) {
            linkedList.add("--import-mappings=" + this.importMappings);
        }
        if (this.typeMappings.length() > 0) {
            linkedList.add("--type-mappings=" + this.typeMappings);
        }
        linkedList.add("--additional-properties=sourceFolder=/");
        linkedList.add(GLOBAL_PROPERTY);
        linkedList.add("modelTests=false,apiTests=false");
        return linkedList;
    }

    private JkOpenapiCmdBuilder() {
    }
}

