/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.openapi;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkSourceGenerator;
import dev.jeka.plugins.openapi.JkOpenApiSourceGenerator;

public class JkOpenApi {
    private final String version;

    private JkOpenApi(String string) {
        this.version = string;
    }

    public static JkOpenApi ofVersion(@JkDepSuggest(versionOnly=true, hint="org.openapitools:openapi-generator-cli:") String string) {
        return new JkOpenApi(string);
    }

    public static JkOpenApi ofDefaultVersion() {
        return JkOpenApi.ofVersion("7.0.1");
    }

    public JkOpenApiSourceGenerator addSourceGenerator(JkProject jkProject, String string, String string2) {
        JkOpenApiSourceGenerator jkOpenApiSourceGenerator = JkOpenApiSourceGenerator.of(string, string2).setCliVersion(this.version);
        jkProject.compilation.addSourceGenerator((JkSourceGenerator)jkOpenApiSourceGenerator);
        return jkOpenApiSourceGenerator;
    }

    public JkOpenApiSourceGenerator addSourceGenerator(JkProject jkProject, String string, String string2, String string3) {
        JkOpenApiSourceGenerator jkOpenApiSourceGenerator = JkOpenApiSourceGenerator.of(string, string2).setCliVersion(this.version).customize(jkOpenapiCmdBuilder -> jkOpenapiCmdBuilder.addApiAndModelPackage(string3).add("--model-name-prefix", "Rest"));
        jkProject.compilation.addSourceGenerator((JkSourceGenerator)jkOpenApiSourceGenerator);
        return jkOpenApiSourceGenerator;
    }

    public JkOpenApiSourceGenerator addSpringbootServerGenerator(JkProject jkProject, String string, String string2) {
        return this.addSourceGenerator(jkProject, "spring", string, string2).customize(jkOpenapiCmdBuilder -> jkOpenapiCmdBuilder.addAdditionalProperties("useSpringBoot3", "true"));
    }

    public JkOpenApiSourceGenerator addJavaGenerator(JkProject jkProject, String string, String string2) {
        return this.addSourceGenerator(jkProject, "client", string, string2);
    }
}

