/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.openapi;

import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkSourceGenerator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.plugins.openapi.JkOpenApiGeneratorCli;
import dev.jeka.plugins.openapi.JkOpenapiCmdBuilder;
import java.nio.file.Path;
import java.util.function.Consumer;

public class JkOpenApiSourceGenerator
extends JkSourceGenerator {
    private final String generatorName;
    private final String inputSpecLocation;
    private String cliVersion = "7.0.1";
    private Consumer<JkOpenapiCmdBuilder> customizer = jkOpenapiCmdBuilder -> {};

    public static JkOpenApiSourceGenerator of(String string, String string2) {
        return new JkOpenApiSourceGenerator(string, string2);
    }

    public static JkOpenApiSourceGenerator ofSpringServer(String string) {
        return new JkOpenApiSourceGenerator("spring", string);
    }

    public static JkOpenApiSourceGenerator ofJavaClient(String string) {
        return new JkOpenApiSourceGenerator("java", string);
    }

    public JkOpenApiSourceGenerator setCliVersion(String string) {
        this.cliVersion = string;
        return this;
    }

    public JkOpenApiSourceGenerator customize(Consumer<JkOpenapiCmdBuilder> consumer) {
        this.customizer = consumer;
        return this;
    }

    public String getDirName() {
        return "openapi";
    }

    protected void generate(JkProject jkProject, Path path) {
        JkOpenApiGeneratorCli jkOpenApiGeneratorCli = JkOpenApiGeneratorCli.of(jkProject.dependencyResolver.getRepos(), this.cliVersion);
        JkOpenapiCmdBuilder jkOpenapiCmdBuilder = JkOpenapiCmdBuilder.of(this.generatorName, this.inputSpecLocation).add("--output", path.toString()).addAdditionalProperties("sourceFolder", "/").addGlobalProperties("modelTests", "false").addGlobalProperties("apiTests", "false");
        if (JkLog.isVerbose()) {
            jkOpenapiCmdBuilder.add("--verbose");
        }
        this.customizer.accept(jkOpenapiCmdBuilder);
        jkOpenApiGeneratorCli.exec(jkOpenapiCmdBuilder.build());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.cliVersion;
    }

    private JkOpenApiSourceGenerator(String string, String string2) {
        this.generatorName = string;
        this.inputSpecLocation = string2;
    }
}

