/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.nodejs;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.KBean;
import dev.jeka.core.tool.builtins.project.ProjectKBean;
import dev.jeka.plugins.nodejs.JkNodeJs;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JkDoc(value="Auto-configure projects with nodeJs client.")
public class NodeJsKBean
extends KBean {
    @JkDoc(value="The version of NodeJs to use")
    @JkDepSuggest(versionOnly=true, hint="20.10.0,18.19.0,16.20.2")
    public String version = "20.10.0";
    @JkDoc(value="Comma separated, command lines to execute for building js application or in conjunction with #exec method. This can be similar to something like 'npx ..., npm ...'")
    public String cmdLine;
    @JkDoc(value="Comma separated, command lines to execute for testing when 'autoConfigureProject'=true")
    public String testCmdLine;
    @JkDoc(value="Path of js project root. It is expected to be relative to the base directory.")
    public String appDir = "app-js";
    @JkDoc(value="Path of the built application (Generally containing an index.html file). It is expected to be relative to the js app dir.")
    public String distDir = "build";
    @JkDoc(value="If not empty, the result of client build will be copied to this dir relative to the generated class dir (e.g. 'static')")
    public String targetResourceDir;
    @JkDoc(value="If true, the project wrapped by ProjectKBean will be configured automatically to build the nodeJs project.")
    public boolean autoConfigureProject = false;

    @JkDoc(value="Execute npm using the command line specified in 'cmdLine' property.")
    public void exec() {
        NodeJsKBean.commandLines(this.cmdLine).forEach(this.getJkNodeJs()::exec);
    }

    @JkDoc(value="Execute the command line specified by 'testCmdLine'")
    public void execTest() {
        NodeJsKBean.commandLines(this.testCmdLine).forEach(this.getJkNodeJs()::exec);
    }

    protected void init() {
        if (this.autoConfigureProject) {
            JkProject project = ((ProjectKBean)this.load(ProjectKBean.class)).project;
            JkNodeJs.ofVersion(this.version).configure(project, this.appDir, this.distDir, this.targetResourceDir, NodeJsKBean.commandLines(this.cmdLine), NodeJsKBean.commandLines(this.testCmdLine));
        }
    }

    public Path getWorkingDir() {
        if (JkUtilsString.isBlank((String)this.appDir)) {
            return this.getBaseDir();
        }
        Path result = this.getBaseDir().resolve(this.appDir);
        if (!Files.exists(result, new LinkOption[0])) {
            JkLog.info((String)"Directory not found %s, use base dir as working dir.", (Object[])new Object[]{result});
            return this.getBaseDir();
        }
        return result;
    }

    private JkNodeJs getJkNodeJs() {
        return JkNodeJs.ofVersion(this.version).setWorkingDir(this.getWorkingDir());
    }

    private static List<String> commandLines(String cmd) {
        if (cmd == null) {
            return Collections.emptyList();
        }
        return Stream.of(cmd.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

