/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.nodejs;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkZipTree;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkConsoleSpinner;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class JkNodeJs {
    public static final String DEFAULT_NODE_VERSION = "20.10.0";
    private static final String DOWNLOAD_BASE_URL = "https://nodejs.org/dist/";
    private Path installDir;
    private String version = "20.10.0";
    private Path workingDir = Paths.get("", new String[0]);

    private JkNodeJs(Path installDir) {
        this.installDir = installDir;
    }

    public static JkNodeJs of(Path nodeJsInstallDir) {
        return new JkNodeJs(nodeJsInstallDir);
    }

    public static JkNodeJs ofVersion(@JkDepSuggest(versionOnly=true, hint="20.10.0,18.19.0,16.20.2") String version) {
        JkNodeJs result = JkNodeJs.of(null);
        result.version = version;
        return result;
    }

    public static JkNodeJs ofDefaultVersion() {
        return JkNodeJs.ofVersion(DEFAULT_NODE_VERSION);
    }

    public JkNodeJs setWorkingDir(Path workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    public String getVersion() {
        return this.version;
    }

    public JkNodeJs npm(String commandLine) {
        String cmd = JkUtilsSystem.IS_WINDOWS ? "npm.cmd" : "bin/npm";
        String[] params = JkUtilsString.parseCommandline((String)commandLine);
        ((JkProcess)this.createProcess(this.workingDir, cmd).setParams(params)).exec();
        return this;
    }

    public JkNodeJs npx(String commandLine) {
        String cmd = JkUtilsSystem.IS_WINDOWS ? "npx.cmd" : "bin/npx";
        String[] params = JkUtilsString.parseCommandline((String)commandLine);
        ((JkProcess)this.createProcess(this.workingDir, cmd).setParams(params)).exec();
        return this;
    }

    public JkNodeJs exec(String commandLine) {
        String command = JkUtilsString.substringBeforeFirst((String)commandLine, (String)" ").trim();
        String args = JkUtilsString.substringAfterFirst((String)commandLine, (String)" ").trim();
        if ("npm".equals(command)) {
            return this.npm(args);
        }
        if ("npx".equals(command)) {
            return this.npx(args);
        }
        throw new IllegalArgumentException("For nodeJs, command line should start with either 'npm' nor 'npx'. Was " + commandLine);
    }

    public JkNodeJs configure(JkProject project, String jsAppBaseDir, String distDir, String copyToDir, List<String> buildCommands, List<String> testCommands) {
        Path jsBaseDir = project.getBaseDir().resolve(jsAppBaseDir);
        Path buildJsDir = jsBaseDir.resolve(distDir);
        project.compilation.postCompileActions.append("build-js", () -> {
            this.setWorkingDir(jsBaseDir);
            JkConsoleSpinner.of((String)"Building NodeJs application").run(() -> buildCommands.forEach(this::exec));
            JkLog.info((String)"JS project built in %s", (Object[])new Object[]{buildJsDir});
            if (!JkUtilsString.isBlank((String)copyToDir)) {
                Path target = project.compilation.layout.resolveClassDir().resolve(copyToDir);
                JkPathTree.of((Path)buildJsDir).copyTo(target, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                JkLog.info((String)"Build copied to %s", (Object[])new Object[]{target});
            }
        });
        if (!testCommands.isEmpty()) {
            project.testing.postActions.append("test-js", () -> {
                this.setWorkingDir(jsBaseDir);
                JkConsoleSpinner.of((String)"Testing NodeJs application").run(() -> testCommands.forEach(this::exec));
                JkLog.info((String)"JS test successful", (Object[])new Object[0]);
            });
        }
        return this;
    }

    private synchronized Path installDir() {
        if (this.installDir == null) {
            this.installDir = JkNodeJs.getDistribPath(this.version);
            if (!JkNodeJs.isBinaryPresent(this.installDir)) {
                JkNodeJs.download(this.version);
            }
        }
        return this.installDir;
    }

    private JkProcess createProcess(Path workingDir, String cmdName) {
        String path = System.getenv("PATH");
        Path commandFile = this.installDir().resolve(cmdName);
        Path nodeDir = commandFile.getParent();
        String pathVar = nodeDir.toString() + File.pathSeparator + path;
        return (JkProcess)((JkProcess)((JkProcess)((JkProcess)((JkProcess)JkProcess.of((String)commandFile.toString(), (String[])new String[0]).setWorkingDir(workingDir)).setFailOnError(true)).setEnv("PATH", pathVar)).setLogCommand(true)).setLogWithJekaDecorator(true);
    }

    private static boolean isBinaryPresent(Path installDir) {
        if (JkUtilsSystem.IS_WINDOWS) {
            return Files.exists(installDir.resolve("npm.cmd"), new LinkOption[0]);
        }
        return Files.exists(installDir.resolve("bin/npm"), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(String version) {
        block18: {
            JkPathFile tempZip = JkPathFile.of((Path)JkUtilsPath.createTempFile((String)"nodejs-downloded", (String)"", (FileAttribute[])new FileAttribute[0]));
            String url = JkNodeJs.constructDownloadUrl(version);
            JkLog.verbose((String)"Downloading %s...", (Object[])new Object[]{url});
            tempZip.fetchContentFrom(JkNodeJs.constructDownloadUrl(version));
            Path distribPath = JkNodeJs.getDistribPath(version);
            JkLog.verbose((String)"unpack %s to %s", (Object[])new Object[]{url, distribPath});
            if (JkUtilsSystem.IS_WINDOWS) {
                try (JkZipTree zipTree = JkZipTree.of((Path)tempZip.get());){
                    ((JkZipTree)zipTree.goTo(JkNodeJs.nodeArchiveFolderName(version))).copyTo(distribPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    break block18;
                }
                finally {
                    JkUtilsPath.deleteFile((Path)tempZip.get());
                }
            }
            Path distribParent = distribPath.getParent();
            JkUtilsPath.createDirectories((Path)distribParent, (FileAttribute[])new FileAttribute[0]);
            ((JkProcess)JkProcess.of((String)"tar", (String[])new String[]{"-xf", tempZip.toString(), "-C", distribParent.toString()}).setLogCommand(true)).run();
            Path extractDir = distribParent.resolve(JkNodeJs.nodeArchiveFolderName(version));
            try {
                Files.move(extractDir, extractDir.resolveSibling(version), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            JkUtilsPath.deleteFile((Path)tempZip.get());
        }
    }

    private static String constructDownloadUrl(String version) {
        String baseUrl = "https://nodejs.org/dist/v" + version + "/" + JkNodeJs.nodeArchiveFolderName(version);
        if (JkUtilsSystem.IS_WINDOWS) {
            return baseUrl + ".zip";
        }
        return baseUrl + ".tar.gz";
    }

    private static String nodeArchiveFolderName(String version) {
        String baseName = "node-v" + version + "-";
        if (JkUtilsSystem.IS_WINDOWS) {
            baseName = baseName + "win-";
            String arch = JkUtilsSystem.getProcessor().is64Bit() ? "x64" : "x86";
            return baseName + arch;
        }
        if (JkUtilsSystem.IS_MACOS) {
            baseName = baseName + "darwin-";
            String arch = JkUtilsSystem.getProcessor().isAarch64() ? "arm64" : "x64";
            return baseName + arch;
        }
        if (JkUtilsSystem.IS_LINUX) {
            baseName = baseName + "linux-";
            String arch = JkUtilsSystem.getProcessor().isAarch64() ? "arm64" : "x64";
            return baseName + arch;
        }
        throw new IllegalStateException("Unknown operating system " + System.getProperty("os.name"));
    }

    private static Path getDistribPath(String version) {
        return JkLocator.getCacheDir().resolve("nodejs").resolve(version);
    }
}

