/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.nodejs;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkZipTree;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsSystem;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.plugins.nodejs.JkNodeJs;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

@JkDoc(value={"Install and run a specified version of NodeJs/npm"})
public class NodeJsJkBean
extends JkBean {
    private static final String BASE_URL = "https://nodejs.org/dist/";
    @JkDoc(value={"The version of NodeJs to use"})
    public String version = "18.12.0";
    @JkDoc(value={"The command line to execute with nodeJs#npm or nodeJs#npx (without command name."})
    public String cmdLine;
    @JkDoc(value={"The relative path of the nodeJs project."})
    public String clientDir = "client";
    private Path workingDir;

    private Path getDistribPath() {
        return JkLocator.getCacheDir().resolve("nodejs").resolve(this.version);
    }

    @JkDoc(value={"Execute npm using the command line specified in 'cmdLine' property."})
    public void npm() {
        this.npm(this.cmdLine);
    }

    @JkDoc(value={"Execute npx using the command line specified in 'cmdLine' property."})
    public void npx() {
        this.npx(this.cmdLine);
    }

    public void npm(String string) {
        Path path = this.getDistribPath();
        JkNodeJs jkNodeJs = JkNodeJs.of(path);
        if (!jkNodeJs.isBinaryPresent()) {
            this.download();
        }
        JkNodeJs.of(path).npm(this.getWorkingDir(), string);
    }

    public void npx(String string) {
        Path path = this.getDistribPath();
        JkNodeJs jkNodeJs = JkNodeJs.of(path);
        if (!jkNodeJs.isBinaryPresent()) {
            this.download();
        }
        JkNodeJs.of(path).npx(this.getWorkingDir(), string);
    }

    public NodeJsJkBean setWorkingDir(Path path) {
        this.workingDir = path;
        return this;
    }

    public NodeJsJkBean setWorkingDir(String string) {
        this.workingDir = this.getBaseDir().resolve(string);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() {
        block18: {
            JkPathFile jkPathFile = JkPathFile.of((Path)JkUtilsPath.createTempFile((String)"nodejs-downloded", (String)"", (FileAttribute[])new FileAttribute[0]));
            String string = this.constructDownloadUrl();
            JkLog.info((String)("Downloading " + string + "... "), (Object[])new Object[0]);
            jkPathFile.fetchContentFrom(this.constructDownloadUrl());
            Path path = this.getDistribPath();
            JkLog.info((String)("unpack " + string + " to " + path), (Object[])new Object[0]);
            if (JkUtilsSystem.IS_WINDOWS) {
                try (JkZipTree jkZipTree = JkZipTree.of((Path)jkPathFile.get());){
                    ((JkZipTree)jkZipTree.goTo(this.nodeArchiveFolderName())).copyTo(path, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    break block18;
                }
                finally {
                    JkUtilsPath.deleteFile((Path)jkPathFile.get());
                }
            }
            Path path2 = path.getParent();
            JkUtilsPath.createDirectories((Path)path2, (FileAttribute[])new FileAttribute[0]);
            JkProcess.of((String)"tar", (String[])new String[]{"-xf", jkPathFile.toString(), "-C", path2.toString()}).setLogCommand(true).run();
            Path path3 = path2.resolve(this.nodeArchiveFolderName());
            try {
                Files.move(path3, path3.resolveSibling(this.version), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            JkUtilsPath.deleteFile((Path)jkPathFile.get());
        }
    }

    private String constructDownloadUrl() {
        String string = "https://nodejs.org/dist/v" + this.version + "/" + this.nodeArchiveFolderName();
        if (JkUtilsSystem.IS_WINDOWS) {
            return string + ".zip";
        }
        return string + ".tar.gz";
    }

    private String nodeArchiveFolderName() {
        String string = "node-v" + this.version + "-";
        if (JkUtilsSystem.IS_WINDOWS) {
            string = string + "win-";
            String string2 = JkUtilsSystem.getProcessor().is64Bit() ? "x64" : "x86";
            return string + string2;
        }
        if (JkUtilsSystem.IS_MACOS) {
            string = string + "darwin-";
            String string3 = JkUtilsSystem.getProcessor().isAarch64() ? "arm64" : "x64";
            return string + string3;
        }
        if (JkUtilsSystem.IS_LINUX) {
            string = string + "linux-";
            String string4 = JkUtilsSystem.getProcessor().isAarch64() ? "arm64" : "x64";
            return string + string4;
        }
        throw new IllegalStateException("Unknown operating system " + System.getProperty("os.name"));
    }

    public Path getWorkingDir() {
        if (this.workingDir != null) {
            return this.workingDir;
        }
        return this.getBaseDir().resolve(this.clientDir);
    }
}

