/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.nodejs;

import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class JkNodeJs {
    private final Path installDir;

    private JkNodeJs(Path path) {
        this.installDir = path;
    }

    public static JkNodeJs of(Path path) {
        return new JkNodeJs(path);
    }

    public void npm(Path path, String string) {
        String string2 = JkUtilsSystem.IS_WINDOWS ? "npm.cmd" : "bin/npm";
        this.createProcess(path, string2).exec(JkUtilsString.translateCommandline((String)string));
    }

    public void npx(Path path, String string) {
        String string2 = JkUtilsSystem.IS_WINDOWS ? "npx.cmd" : "bin/npx";
        this.createProcess(path, string2).exec(JkUtilsString.translateCommandline((String)string));
    }

    private JkProcess createProcess(Path path, String string) {
        String string2 = System.getenv("PATH");
        String string3 = this.installDir.toString() + File.pathSeparator + string2;
        return JkProcess.of((String)this.installDir.resolve(string).toString(), (String[])new String[0]).setWorkingDir(path).setFailOnError(true).setEnv("PATH", string3).setLogCommand(true).setLogOutput(true);
    }

    public boolean isBinaryPresent() {
        if (JkUtilsSystem.IS_WINDOWS) {
            return Files.exists(this.installDir.resolve("npm.cmd"), new LinkOption[0]);
        }
        return Files.exists(this.installDir.resolve("bin/npm"), new LinkOption[0]);
    }
}

