/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.kotlin;

import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.kotlin.JkKotlinCompiler;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.KBean;
import dev.jeka.core.tool.builtins.project.ProjectKBean;
import dev.jeka.plugins.kotlin.JkKotlinJvm;
import java.util.Optional;

@JkDoc(value="Explain here what your plugin is doing.\nNo need to list methods or options here has you are supposed to annotate them directly.")
public class KotlinJvmKBean
extends KBean {
    private static final String DEFAULT_VERSION = "1.8.0";
    @JkDoc(value="The Kotlin version for compiling and running")
    private String kotlinVersion;
    @JkDoc(value="Location of Kotlin sources")
    private String kotlinSourceDir = "src/main/kotlin";
    @JkDoc(value="Location of Kotlin sources for tests")
    private String kotlinTestSourceDir = "src/test/kotlin";
    @JkDoc(value="Include standard lib in for compiling")
    private boolean addStdlib = true;
    @JkDoc(value="If true, the project KBean will be automatically configured to use Kotlin.")
    private boolean autoConfigureProject = false;
    private JkKotlinJvm kotlinJvmProject;

    protected void init() {
        if (this.autoConfigureProject) {
            JkProject project = ((ProjectKBean)this.load(ProjectKBean.class)).project;
            this.getKotlinJvm().configure(project, this.kotlinSourceDir, this.kotlinTestSourceDir);
        }
    }

    public JkKotlinJvm getKotlinJvm() {
        if (this.kotlinJvmProject != null) {
            return this.kotlinJvmProject;
        }
        JkKotlinCompiler kotlinCompiler = JkKotlinCompiler.ofJvm((JkRepoSet)this.getRunbase().getDependencyResolver().getRepos(), (String)this.getKotlinVersion());
        this.kotlinJvmProject = JkKotlinJvm.of(kotlinCompiler).setAddStdlib(this.addStdlib);
        return this.kotlinJvmProject;
    }

    private String getKotlinVersion() {
        String result = this.kotlinVersion;
        if (result == null) {
            result = Optional.ofNullable(this.getRunbase().getProperties().get("jeka.kotlin.version")).orElse(DEFAULT_VERSION);
        }
        return result;
    }
}

