/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.kotlin;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.kotlin.JkKotlinCompiler;
import dev.jeka.core.api.kotlin.JkKotlinJvmCompileSpec;
import dev.jeka.core.api.kotlin.JkKotlinModules;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.system.JkConsoleSpinner;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.function.Function;

public class JkKotlinJvm {
    public static final String KOTLIN_JVM_SOURCES_COMPILE_ACTION = "compile-kotlin-jvm-sources";
    private final JkKotlinCompiler kotlinCompiler;
    private boolean addStdlib = true;
    private String jvmVersion = JkJavaVersion.ofCurrent().toString();

    private JkKotlinJvm(JkKotlinCompiler kotlinCompiler) {
        this.kotlinCompiler = kotlinCompiler;
    }

    public static JkKotlinJvm of(JkKotlinCompiler kotlinCompiler) {
        return new JkKotlinJvm(kotlinCompiler);
    }

    public static JkKotlinJvm of() {
        return new JkKotlinJvm(null);
    }

    public JkKotlinJvm setAddStdlib(boolean addStdlib) {
        this.addStdlib = addStdlib;
        return this;
    }

    public JkKotlinJvm setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
        return this;
    }

    public JkKotlinCompiler getKotlinCompiler() {
        return this.kotlinCompiler;
    }

    public void configure(JkProject project, String kotlinSourceDir, String kotlinTestSourceDir) {
        if (!JkUtilsString.isBlank((String)kotlinSourceDir)) {
            project.compilation.layout.setSources(kotlinTestSourceDir);
        }
        if (!JkUtilsString.isBlank((String)kotlinTestSourceDir)) {
            project.testing.compilation.layout.setSources(kotlinTestSourceDir);
        }
        JkProjectCompilation prodCompile = project.compilation;
        JkProjectCompilation testCompile = project.testing.compilation;
        prodCompile.customizeDependencies((Function<JkDependencySet, JkDependencySet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$configure$0(dev.jeka.core.api.depmanagement.JkDependencySet ), (Ldev/jeka/core/api/depmanagement/JkDependencySet;)Ldev/jeka/core/api/depmanagement/JkDependencySet;)((JkKotlinJvm)this)).preCompileActions.replaceOrInsertBefore(KOTLIN_JVM_SOURCES_COMPILE_ACTION, "compile-java-sources", () -> this.compileKotlinInSpinner(project, kotlinSourceDir));
        testCompile.preCompileActions.replaceOrInsertBefore(KOTLIN_JVM_SOURCES_COMPILE_ACTION, "compile-java-sources", () -> this.compileTestKotlinInSpinner(project, kotlinTestSourceDir));
        JkPathTree javaInKotlinDir = JkPathTree.of((Path)project.getBaseDir().resolve(kotlinSourceDir));
        JkPathTree javaInKotlinTestDir = JkPathTree.of((Path)project.getBaseDir().resolve(kotlinTestSourceDir));
        prodCompile.layout.setSources(javaInKotlinDir);
        testCompile.layout.setSources(javaInKotlinTestDir);
        if (this.addStdlib) {
            prodCompile.customizeDependencies(this::addStdLibsToProdDeps);
            testCompile.customizeDependencies(this::addStdLibsToTestDeps);
        }
    }

    private JkVersionProvider kotlinVersionProvider() {
        return JkKotlinModules.versionProvider((String)this.kotlinCompiler.getVersion());
    }

    private void compileKotlinInSpinner(JkProject javaProject, String kotlinSourceDir) {
        JkConsoleSpinner.of((String)"Compiling Kotlin sources").setAlternativeMassage("Compiling Kotlin sources. It may take a while...").run(() -> this.compileKotlin(javaProject, kotlinSourceDir));
    }

    private void compileKotlin(JkProject javaProject, String kotlinSourceDir) {
        JkProjectCompilation compilation = javaProject.compilation;
        JkPathTreeSet sources = compilation.layout.resolveSources();
        if (!JkUtilsString.isBlank((String)kotlinSourceDir)) {
            sources = sources.and(new Path[]{javaProject.getBaseDir().resolve(kotlinSourceDir)});
        }
        if (sources.count(1, false) == 0) {
            JkLog.info((String)("No source to compile in " + sources), (Object[])new Object[0]);
            return;
        }
        JkJavaVersion targetVersion = javaProject.getJvmTargetVersion();
        if (targetVersion == null) {
            targetVersion = JkJavaVersion.of((String)this.jvmVersion);
        }
        JkKotlinJvmCompileSpec compileSpec = JkKotlinJvmCompileSpec.of().setClasspath((Iterable)compilation.resolveDependenciesAsFiles()).setOutputDir(compilation.layout.getOutputDir().resolve("classes")).setTargetVersion(targetVersion).setSources(sources);
        this.kotlinCompiler.compile(compileSpec);
    }

    private void compileTestKotlinInSpinner(JkProject javaProject, String kotlinTestSourceDir) {
        JkConsoleSpinner.of((String)"Compiling Kotlin test sources").setAlternativeMassage("Compiling Kotlin stest ources. It may take a while...").run(() -> this.compileTestKotlin(javaProject, kotlinTestSourceDir));
    }

    private void compileTestKotlin(JkProject javaProject, String kotlinTestSourceDir) {
        JkProjectCompilation compilation = javaProject.testing.compilation;
        JkPathTreeSet sources = compilation.layout.resolveSources();
        if (JkUtilsString.isBlank((String)kotlinTestSourceDir)) {
            sources = sources.and(new Path[]{javaProject.getBaseDir().resolve(kotlinTestSourceDir)});
        }
        if (sources.count(1, false) == 0) {
            JkLog.info((String)("No source to compile in " + sources), (Object[])new Object[0]);
            return;
        }
        JkPathSequence classpath = JkPathSequence.of((Iterable)compilation.resolveDependenciesAsFiles()).and((Iterable)compilation.layout.getClassDirPath());
        JkKotlinJvmCompileSpec compileSpec = JkKotlinJvmCompileSpec.of().setSources(compilation.layout.resolveSources()).setClasspath((Iterable)classpath).setOutputDir(compilation.layout.getOutputDir().resolve("test-classes")).setTargetVersion(javaProject.getJvmTargetVersion());
        this.kotlinCompiler.compile(compileSpec);
    }

    private JkDependencySet addStdLibsToProdDeps(JkDependencySet deps) {
        return this.kotlinCompiler.isProvidedCompiler() ? deps.andFiles((Iterable)this.kotlinCompiler.getStdLib()) : deps.and("org.jetbrains.kotlin:kotlin-stdlib-jdk8", new Object[0]).and("org.jetbrains.kotlin:kotlin-reflect", new Object[0]);
    }

    private JkDependencySet addStdLibsToTestDeps(JkDependencySet deps) {
        return this.kotlinCompiler.isProvidedCompiler() ? deps.and("org.jetbrains.kotlin:kotlin-test", new Object[0]) : deps;
    }

    private /* synthetic */ JkDependencySet lambda$configure$0(JkDependencySet deps) {
        return deps.andVersionProvider(this.kotlinVersionProvider());
    }
}

