/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.kotlin;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkRepoProperties;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.function.JkConsumers;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.kotlin.JkKotlinCompiler;
import dev.jeka.core.api.kotlin.JkKotlinJvmCompileSpec;
import dev.jeka.core.api.kotlin.JkKotlinModules;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@JkDoc(value={"Explain here what your plugin is doing.\nNo need to list methods or options here has you are supposed to annotate them directly."})
public class KotlinJvmJkBean
extends JkBean {
    public static final String KOTLIN_JVM_SOURCES_COMPILE_ACTION = "kotlin-jvm-sources-compile";
    private static final String DEFAULT_VERSION = "1.8.0";
    @JkDoc(value={"The Kotlin version for compiling and running"})
    public String kotlinVersion;
    public String kotlinSourceDir = "src/main/kotlin";
    public String kotlinTestSourceDir = "src/test/kotlin";
    @JkDoc(value={"Include standard lib in for compiling"})
    public boolean addStdlib = true;
    @JkDoc(value={"If true, the project KBean will be automatically configured to use Kotlin."})
    public boolean configureProject = true;
    private JkKotlinCompiler kotlinCompiler;
    private JkRepoSet downloadRepos;
    private final JkConsumers<JkKotlinCompiler> compilerConfigurators = JkConsumers.of();

    KotlinJvmJkBean() {
        this.kotlinVersion = Optional.of(this.getRuntime().getProperties().get("jeka.kotlin.version")).orElse(DEFAULT_VERSION);
        this.downloadRepos = JkRepoProperties.of((JkProperties)this.getRuntime().getProperties()).getDownloadRepos();
        Optional projectJkBean = this.getRuntime().getBeanOptional(ProjectJkBean.class);
        projectJkBean.ifPresent(bean -> this.automateConfigure((ProjectJkBean)bean));
    }

    public KotlinJvmJkBean setDownloadRepos(JkRepoSet downloadRepos) {
        this.downloadRepos = downloadRepos;
        return this;
    }

    private void automateConfigure(ProjectJkBean projectJkBean) {
        if (!this.configureProject) {
            return;
        }
        projectJkBean.lately(this::configure);
    }

    public void configure(JkProject project) {
        if (!JkUtilsString.isBlank((String)this.kotlinSourceDir)) {
            project.compilation.layout.setSources(this.kotlinTestSourceDir);
        }
        if (!JkUtilsString.isBlank((String)this.kotlinTestSourceDir)) {
            project.testing.compilation.layout.setSources(this.kotlinTestSourceDir);
        }
        JkProjectCompilation prodCompile = project.compilation;
        JkProjectCompilation testCompile = project.testing.compilation;
        prodCompile.configureDependencies((Function<JkDependencySet, JkDependencySet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$configure$1(dev.jeka.core.api.depmanagement.JkDependencySet ), (Ldev/jeka/core/api/depmanagement/JkDependencySet;)Ldev/jeka/core/api/depmanagement/JkDependencySet;)((KotlinJvmJkBean)this)).preCompileActions.appendBefore(KOTLIN_JVM_SOURCES_COMPILE_ACTION, "java-sources-compile", () -> this.compileKotlin(this.getCompiler(), project));
        testCompile.preCompileActions.appendBefore(KOTLIN_JVM_SOURCES_COMPILE_ACTION, "java-sources-compile", () -> this.compileTestKotlin(this.getCompiler(), project));
        testCompile.layout.addSource(this.kotlinTestSourceDir);
        JkPathTree javaInKotlinDir = JkPathTree.of((Path)project.getBaseDir().resolve(this.kotlinSourceDir));
        JkPathTree javaInKotlinTestDir = JkPathTree.of((Path)project.getBaseDir().resolve(this.kotlinTestSourceDir));
        prodCompile.layout.setSources(javaInKotlinDir);
        testCompile.layout.setSources(javaInKotlinTestDir);
        if (this.addStdlib) {
            prodCompile.configureDependencies(this::addStdLibsToProdDeps);
            testCompile.configureDependencies(this::addStdLibsToTestDeps);
        }
    }

    public KotlinJvmJkBean latelyConfigureCompiler(Consumer<JkKotlinCompiler> compilerConsumer) {
        if (this.kotlinCompiler != null) {
            throw new IllegalStateException("The compiler has already been instantiated. Use this method in the constructor of your KBean in order to configure the kompiler at creation time.");
        }
        this.compilerConfigurators.append(compilerConsumer);
        return this;
    }

    private JkDependencySet addStdLibsToProdDeps(JkDependencySet deps) {
        return this.getCompiler().isProvidedCompiler() ? deps.andFiles((Iterable)this.getCompiler().getStdLib()) : deps.and("org.jetbrains.kotlin:kotlin-stdlib-jdk8").and("org.jetbrains.kotlin:kotlin-reflect");
    }

    private JkDependencySet addStdLibsToTestDeps(JkDependencySet deps) {
        return this.getCompiler().isProvidedCompiler() ? deps.and("org.jetbrains.kotlin:kotlin-test") : deps;
    }

    private JkVersionProvider kotlinVersionProvider() {
        return JkKotlinModules.versionProvider((String)this.getCompiler().getVersion());
    }

    public JkKotlinCompiler getCompiler() {
        if (this.kotlinCompiler != null) {
            return this.kotlinCompiler;
        }
        if (JkUtilsString.isBlank((String)this.kotlinVersion)) {
            this.kotlinCompiler = JkKotlinCompiler.ofKotlinHomeCommand((String)"kotlinc");
            JkLog.warn((String)("No version of kotlin has been specified, will use the version installed on KOTLIN_HOME : " + this.kotlinCompiler.getVersion()), (Object[])new Object[0]);
        } else {
            this.kotlinCompiler = JkKotlinCompiler.ofJvm((JkRepoSet)this.downloadRepos, (String)this.kotlinVersion);
        }
        this.kotlinCompiler.setLogOutput(true);
        this.compilerConfigurators.accept((Object)this.kotlinCompiler);
        return this.kotlinCompiler;
    }

    private void compileKotlin(JkKotlinCompiler kotlinCompiler, JkProject javaProject) {
        JkProjectCompilation compilation = javaProject.compilation;
        JkPathTreeSet sources = compilation.layout.resolveSources().and(new Path[]{javaProject.getBaseDir().resolve(this.kotlinSourceDir)});
        if (sources.count(1, false) == 0) {
            JkLog.info((String)("No source to compile in " + sources), (Object[])new Object[0]);
            return;
        }
        JkJavaVersion targetVersion = javaProject.getJvmTargetVersion();
        if (targetVersion == null) {
            targetVersion = JkJavaVersion.of((String)this.getRuntime().getProperties().get("jeka.java.version"));
        }
        JkKotlinJvmCompileSpec compileSpec = JkKotlinJvmCompileSpec.of().setClasspath((Iterable)compilation.resolveDependencies().getFiles()).setOutputDir(compilation.layout.getOutputDir().resolve("classes")).setTargetVersion(targetVersion).setSources(sources);
        kotlinCompiler.compile(compileSpec);
    }

    private void compileTestKotlin(JkKotlinCompiler kotlinCompiler, JkProject javaProject) {
        JkProjectCompilation compilation = javaProject.testing.compilation;
        JkPathTreeSet sources = compilation.layout.resolveSources();
        if (this.kotlinTestSourceDir == null) {
            sources = sources.and(new Path[]{javaProject.getBaseDir().resolve(this.kotlinTestSourceDir)});
        }
        if (sources.count(1, false) == 0) {
            JkLog.info((String)("No source to compile in " + sources), (Object[])new Object[0]);
            return;
        }
        JkPathSequence classpath = compilation.resolveDependencies().getFiles().and((Iterable)compilation.layout.getClassDirPath());
        JkKotlinJvmCompileSpec compileSpec = JkKotlinJvmCompileSpec.of().setSources(compilation.layout.resolveSources()).setClasspath((Iterable)classpath).setOutputDir(compilation.layout.getOutputDir().resolve("test-classes")).setTargetVersion(javaProject.getJvmTargetVersion());
        kotlinCompiler.compile(compileSpec);
    }

    private /* synthetic */ JkDependencySet lambda$configure$1(JkDependencySet deps) {
        return deps.andVersionProvider(this.kotlinVersionProvider());
    }
}

