/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.kotlin;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkRepoProperties;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.function.JkConsumers;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.kotlin.JkKotlinCompiler;
import dev.jeka.core.api.kotlin.JkKotlinJvmCompileSpec;
import dev.jeka.core.api.kotlin.JkKotlinModules;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@JkDoc(value={"Explain here what your plugin is doing.\nNo need to list methods or options here has you are supposed to annotate them directly."})
public class KotlinJvmJkBean
extends JkBean {
    public static final String KOTLIN_JVM_SOURCES_COMPILE_ACTION = "kotlin-jvm-sources-compile";
    private static final String DEFAULT_VERSION = "1.8.0";
    @JkDoc(value={"The Kotlin version for compiling and running"})
    public String kotlinVersion;
    public String kotlinSourceDir = "src/main/kotlin";
    public String kotlinTestSourceDir = "src/test/kotlin";
    @JkDoc(value={"Include standard lib in for compiling"})
    public boolean addStdlib = true;
    @JkDoc(value={"If true, the project KBean will be automatically configured to use Kotlin."})
    public boolean configureProject = true;
    private JkKotlinCompiler kotlinCompiler;
    private JkRepoSet downloadRepos;
    private final JkConsumers<JkKotlinCompiler> compilerConfigurators = JkConsumers.of();

    KotlinJvmJkBean() {
        this.kotlinVersion = Optional.of(this.getRuntime().getProperties().get("jeka.kotlin.version")).orElse(DEFAULT_VERSION);
        this.downloadRepos = JkRepoProperties.of((JkProperties)this.getRuntime().getProperties()).getDownloadRepos();
        Optional optional = this.getRuntime().getBeanOptional(ProjectJkBean.class);
        optional.ifPresent(projectJkBean -> this.automateConfigure((ProjectJkBean)projectJkBean));
    }

    public KotlinJvmJkBean setDownloadRepos(JkRepoSet jkRepoSet) {
        this.downloadRepos = jkRepoSet;
        return this;
    }

    private void automateConfigure(ProjectJkBean projectJkBean) {
        if (!this.configureProject) {
            return;
        }
        projectJkBean.lately(this::configure);
    }

    public void configure(JkProject jkProject) {
        if (!JkUtilsString.isBlank((String)this.kotlinSourceDir)) {
            jkProject.compilation.layout.setSources(this.kotlinTestSourceDir);
        }
        if (!JkUtilsString.isBlank((String)this.kotlinTestSourceDir)) {
            jkProject.testing.compilation.layout.setSources(this.kotlinTestSourceDir);
        }
        JkProjectCompilation jkProjectCompilation = jkProject.compilation;
        JkProjectCompilation jkProjectCompilation2 = jkProject.testing.compilation;
        jkProjectCompilation.configureDependencies((Function<JkDependencySet, JkDependencySet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$configure$1(dev.jeka.core.api.depmanagement.JkDependencySet ), (Ldev/jeka/core/api/depmanagement/JkDependencySet;)Ldev/jeka/core/api/depmanagement/JkDependencySet;)((KotlinJvmJkBean)this)).preCompileActions.appendBefore(KOTLIN_JVM_SOURCES_COMPILE_ACTION, "java-sources-compile", () -> this.compileKotlin(this.getCompiler(), jkProject));
        jkProjectCompilation2.preCompileActions.appendBefore(KOTLIN_JVM_SOURCES_COMPILE_ACTION, "java-sources-compile", () -> this.compileTestKotlin(this.getCompiler(), jkProject));
        jkProjectCompilation2.layout.addSource(this.kotlinTestSourceDir);
        JkPathTree jkPathTree = JkPathTree.of((Path)jkProject.getBaseDir().resolve(this.kotlinSourceDir));
        JkPathTree jkPathTree2 = JkPathTree.of((Path)jkProject.getBaseDir().resolve(this.kotlinTestSourceDir));
        jkProjectCompilation.layout.setSources(jkPathTree);
        jkProjectCompilation2.layout.setSources(jkPathTree2);
        if (this.addStdlib) {
            jkProjectCompilation.configureDependencies(this::addStdLibsToProdDeps);
            jkProjectCompilation2.configureDependencies(this::addStdLibsToTestDeps);
        }
    }

    public KotlinJvmJkBean configureCompiler(Consumer<JkKotlinCompiler> consumer) {
        if (this.kotlinCompiler != null) {
            throw new IllegalStateException("The compiler has already been instantiated. Use this method in the constructor of your KBean in order to configure the kompiler at creation time.");
        }
        this.compilerConfigurators.append(consumer);
        return this;
    }

    private JkDependencySet addStdLibsToProdDeps(JkDependencySet jkDependencySet) {
        return this.getCompiler().isProvidedCompiler() ? jkDependencySet.andFiles((Iterable)this.getCompiler().getStdLib()) : jkDependencySet.and("org.jetbrains.kotlin:kotlin-stdlib-jdk8").and("org.jetbrains.kotlin:kotlin-reflect");
    }

    private JkDependencySet addStdLibsToTestDeps(JkDependencySet jkDependencySet) {
        return this.getCompiler().isProvidedCompiler() ? jkDependencySet.and("org.jetbrains.kotlin:kotlin-test") : jkDependencySet;
    }

    private JkVersionProvider kotlinVersionProvider() {
        return JkKotlinModules.versionProvider((String)this.getCompiler().getVersion());
    }

    public JkKotlinCompiler getCompiler() {
        if (this.kotlinCompiler != null) {
            return this.kotlinCompiler;
        }
        if (JkUtilsString.isBlank((String)this.kotlinVersion)) {
            this.kotlinCompiler = JkKotlinCompiler.ofKotlinHomeCommand((String)"kotlinc");
            JkLog.warn((String)("No version of kotlin has been specified, will use the version installed on KOTLIN_HOME : " + this.kotlinCompiler.getVersion()), (Object[])new Object[0]);
        } else {
            this.kotlinCompiler = JkKotlinCompiler.ofJvm((JkRepoSet)this.downloadRepos, (String)this.kotlinVersion);
        }
        this.kotlinCompiler.setLogOutput(true);
        this.compilerConfigurators.accept((Object)this.kotlinCompiler);
        return this.kotlinCompiler;
    }

    private void compileKotlin(JkKotlinCompiler jkKotlinCompiler, JkProject jkProject) {
        JkProjectCompilation jkProjectCompilation = jkProject.compilation;
        JkPathTreeSet jkPathTreeSet = jkProjectCompilation.layout.resolveSources().and(new Path[]{jkProject.getBaseDir().resolve(this.kotlinSourceDir)});
        if (jkPathTreeSet.count(1, false) == 0) {
            JkLog.info((String)("No source to compile in " + jkPathTreeSet), (Object[])new Object[0]);
            return;
        }
        JkJavaVersion jkJavaVersion = jkProject.getJvmTargetVersion();
        if (jkJavaVersion == null) {
            jkJavaVersion = JkJavaVersion.of((String)this.getRuntime().getProperties().get("jeka.java.version"));
        }
        JkKotlinJvmCompileSpec jkKotlinJvmCompileSpec = JkKotlinJvmCompileSpec.of().setClasspath((Iterable)jkProjectCompilation.resolveDependencies().getFiles()).setOutputDir(jkProjectCompilation.layout.getOutputDir().resolve("classes")).setTargetVersion(jkJavaVersion).setSources(jkPathTreeSet);
        jkKotlinCompiler.compile(jkKotlinJvmCompileSpec);
    }

    private void compileTestKotlin(JkKotlinCompiler jkKotlinCompiler, JkProject jkProject) {
        JkProjectCompilation jkProjectCompilation = jkProject.testing.compilation;
        JkPathTreeSet jkPathTreeSet = jkProjectCompilation.layout.resolveSources();
        if (this.kotlinTestSourceDir == null) {
            jkPathTreeSet = jkPathTreeSet.and(new Path[]{jkProject.getBaseDir().resolve(this.kotlinTestSourceDir)});
        }
        if (jkPathTreeSet.count(1, false) == 0) {
            JkLog.info((String)("No source to compile in " + jkPathTreeSet), (Object[])new Object[0]);
            return;
        }
        JkPathSequence jkPathSequence = jkProjectCompilation.resolveDependencies().getFiles().and((Iterable)jkProjectCompilation.layout.getClassDirPath());
        JkKotlinJvmCompileSpec jkKotlinJvmCompileSpec = JkKotlinJvmCompileSpec.of().setSources(jkProjectCompilation.layout.resolveSources()).setClasspath((Iterable)jkPathSequence).setOutputDir(jkProjectCompilation.layout.getOutputDir().resolve("test-classes")).setTargetVersion(jkProject.getJvmTargetVersion());
        jkKotlinCompiler.compile(jkKotlinJvmCompileSpec);
    }

    private /* synthetic */ JkDependencySet lambda$configure$1(JkDependencySet jkDependencySet) {
        return jkDependencySet.andVersionProvider(this.kotlinVersionProvider());
    }
}

