/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.java.project.JkJavaProject;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkClass;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkDocPluginDeps;
import dev.jeka.core.tool.JkPlugin;
import dev.jeka.core.tool.builtins.java.JkPluginJava;
import dev.jeka.plugins.jacoco.JkJacoco;

@JkDoc(value={"Run unit tests with Jacoco agent coverage test tool."})
@JkDocPluginDeps(value={JkPluginJava.class})
public class JkPluginJacoco
extends JkPlugin {
    public static final String OUTPUT_RELATIVE_PATH = "jacoco/jacoco.exec";
    public static final String OUTPUT_XML_RELATIVE_PATH = "jacoco/jacoco.xml";
    @JkDoc(value={"If false, tests will be run without Jacoco."})
    public boolean enabled = true;
    @JkDoc(value={"If true, Jacoco will produce a standard XML report usable by Sonarqube."})
    public boolean xmlReport = true;
    @JkDoc(value={"Options string, as '[option1]=[value1],[option2]=[value2]', to pass to agent as described here : https://www.jacoco.org/jacoco/trunk/doc/agent.html"})
    public String agentOptions;
    @JkDoc(value={"Exclusion patterns separated with ',' to exclude some class files from the XML report input. An example is 'META-INF/**/*.jar'."})
    public String classDirExcludes;

    protected JkPluginJacoco(JkClass jkClass) {
        super(jkClass);
    }

    @JkDoc(value={"Configures java plugin in order unit tests are run with Jacoco coverage tool. Result is located in [OUTPUT DIR]/jacoco/jacoco.exec file."})
    protected void afterSetup() {
        if (!this.enabled) {
            return;
        }
        JkPluginJava jkPluginJava = (JkPluginJava)this.getJkClass().getPlugins().get(JkPluginJava.class);
        JkJavaProject jkJavaProject = jkPluginJava.getProject();
        JkJacoco jkJacoco = JkJacoco.of(jkJavaProject.getOutputDir().resolve(OUTPUT_RELATIVE_PATH)).setClassDir(jkJavaProject.getConstruction().getCompilation().getLayout().getClassDirPath());
        if (this.xmlReport) {
            jkJacoco.addReportOptions("--xml", jkJavaProject.getOutputDir().resolve(OUTPUT_XML_RELATIVE_PATH).toString());
        }
        if (!JkUtilsString.isBlank((String)this.classDirExcludes)) {
            JkPathMatcher jkPathMatcher = JkPathMatcher.of((boolean)false, (String[])this.classDirExcludes.split(","));
            jkJacoco.setClassDirFilter(jkPathMatcher);
        }
        if (!JkUtilsString.isBlank((String)this.agentOptions)) {
            jkJacoco.addAgentOptions(this.agentOptions.split(","));
        }
        jkJacoco.configure(jkJavaProject.getConstruction().getTesting().getTestProcessor());
    }
}

