/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.java.JkInternalClassloader;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.java.testing.JkTestProcessor;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.plugins.jacoco.JkPluginJacoco;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class JkJacoco {
    private Path agent;
    private Path execFile;
    private Path classDir;
    private final List<String> agentOptions = new LinkedList<String>();
    private final List<String> reportOptions = new LinkedList<String>();

    private JkJacoco(Path path, Path path2) {
        this.agent = path;
        this.execFile = path2;
    }

    public static JkJacoco of(Path path) {
        URL uRL = JkPluginJacoco.class.getResource("org.jacoco.agent-0.8.7-runtime.jar");
        Path path2 = JkUtilsIO.copyUrlContentToCacheFile((URL)uRL, (PrintStream)System.out, (Path)JkInternalClassloader.URL_CACHE_DIR);
        return new JkJacoco(path2, path);
    }

    public JkJacoco setAgent(Path path) {
        this.agent = path;
        return this;
    }

    public JkJacoco addAgentOptions(String ... stringArray) {
        this.agentOptions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public JkJacoco setClassDir(Path path) {
        this.classDir = path;
        return this;
    }

    public JkJacoco addReportOptions(String ... stringArray) {
        this.reportOptions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public List<String> getReportOptions() {
        return this.reportOptions;
    }

    public void configure(JkTestProcessor jkTestProcessor) {
        jkTestProcessor.getPreActions().append(() -> {
            JkJavaProcess jkJavaProcess = (JkJavaProcess)JkUtilsObject.firstNonNull((Object[])new JkJavaProcess[]{jkTestProcessor.getForkingProcess(), JkJavaProcess.ofJava((String)JkTestProcessor.class.getName())});
            jkJavaProcess.addAgent(this.agent, this.agentOptions());
            jkTestProcessor.setForkingProcess(jkJavaProcess);
            jkTestProcessor.getPostActions().append((Runnable)new Reporter());
        });
    }

    private String agentOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("destfile=").append(this.execFile.toAbsolutePath());
        if (Files.exists(this.execFile, new LinkOption[0])) {
            stringBuilder.append(",append=true");
        }
        for (String string : this.agentOptions) {
            stringBuilder.append(",").append(string);
        }
        return stringBuilder.toString();
    }

    private class Reporter
    implements Runnable {
        private Reporter() {
        }

        @Override
        public void run() {
            JkLog.info((String)("Jacoco internal report created at " + JkJacoco.this.execFile.toAbsolutePath()), (Object[])new Object[0]);
            if (!JkJacoco.this.reportOptions.isEmpty()) {
                if (JkJacoco.this.classDir == null) {
                    JkLog.warn((String)"No class dir specified. Cannot run jacoco report.");
                    return;
                }
                if (!Files.exists(JkJacoco.this.execFile, new LinkOption[0])) {
                    JkLog.warn((String)("File " + JkJacoco.this.execFile + " not found. Cannot run jacoco report."));
                    return;
                }
                URL uRL = JkPluginJacoco.class.getResource("org.jacoco.cli-0.8.7-nodeps.jar");
                Path path = JkUtilsIO.copyUrlContentToCacheFile((URL)uRL, (PrintStream)System.out, (Path)JkInternalClassloader.URL_CACHE_DIR);
                LinkedList<String> linkedList = new LinkedList<String>();
                linkedList.add("report");
                linkedList.add(JkJacoco.this.execFile.toAbsolutePath().toString());
                linkedList.add("--classfiles");
                linkedList.add(JkJacoco.this.classDir.toString());
                linkedList.add("--encoding");
                linkedList.add("utf-8");
                linkedList.addAll(JkJacoco.this.reportOptions);
                JkLog.info((String)"Generate Jacoco report", (Object[])new Object[0]);
                ((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJavaJar((Path)path, null).setFailOnError(true)).setLogCommand(true)).addParams(linkedList)).exec(new String[0]);
            }
        }
    }
}

