/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.depmanagement.JkCoordinateFileProxy;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.testing.JkTestProcessor;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class JkJacoco {
    private final RepoToolProvider toolProvider;
    private Path execFile;
    private Path classDir;
    private JkPathMatcher classDirFilter;
    private List<Path> sourceDirs = new LinkedList<Path>();
    private final List<String> agentOptions = new LinkedList<String>();
    private final List<String> reportOptions = new LinkedList<String>();

    private JkJacoco(RepoToolProvider repoToolProvider) {
        this.toolProvider = repoToolProvider;
    }

    public static JkJacoco ofManaged(JkDependencyResolver jkDependencyResolver, String string) {
        return new JkJacoco(new RepoToolProvider(jkDependencyResolver, string));
    }

    public static JkJacoco ofManaged(JkRepoSet jkRepoSet, String string) {
        return JkJacoco.ofManaged(JkDependencyResolver.of().addRepos(jkRepoSet), string);
    }

    public static JkJacoco ofManaged(String string) {
        return JkJacoco.ofManaged(JkRepo.ofMavenCentral().toSet(), string);
    }

    public JkJacoco setExecFile(Path path) {
        this.execFile = path;
        return this;
    }

    public JkJacoco addAgentOptions(String ... stringArray) {
        this.agentOptions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public JkJacoco setClassDir(Path path) {
        this.classDir = path;
        return this;
    }

    public JkJacoco setClassDirFilter(JkPathMatcher jkPathMatcher) {
        this.classDirFilter = jkPathMatcher;
        return this;
    }

    public JkJacoco addReportOptions(String ... stringArray) {
        this.reportOptions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public JkJacoco setSources(List<Path> list) {
        this.sourceDirs = list;
        return this;
    }

    public List<String> getReportOptions() {
        return this.reportOptions;
    }

    public void configure(JkTestProcessor jkTestProcessor) {
        JkUtilsAssert.state((this.execFile != null ? 1 : 0) != 0, (String)"The exec file has not been specified.", (Object[])new Object[0]);
        jkTestProcessor.getPreActions().append(() -> {
            String string = this.agentOptions();
            JkJavaProcess jkJavaProcess = (JkJavaProcess)JkUtilsObject.firstNonNull((Object[])new JkJavaProcess[]{jkTestProcessor.getForkingProcess(), JkJavaProcess.ofJava((String)JkTestProcessor.class.getName())});
            jkJavaProcess.addAgent(this.toolProvider.getAgentJar(), string);
            JkLog.info((String)("Instrumenting tests with Jacoco agent options : " + string), (Object[])new Object[0]);
            jkTestProcessor.setForkingProcess(jkJavaProcess);
            jkTestProcessor.getPostActions().append(this::generateExport);
        });
    }

    private JkPathTree pathTree() {
        JkUtilsAssert.state((this.classDir != null ? 1 : 0) != 0, (String)"Class dir has not been specified.", (Object[])new Object[0]);
        JkPathTree jkPathTree = JkPathTree.of((Path)this.classDir);
        if (this.classDirFilter != null) {
            jkPathTree = jkPathTree.withMatcher(this.classDirFilter);
        }
        return jkPathTree;
    }

    private String agentOptions() {
        String string2 = String.join((CharSequence)",", this.agentOptions);
        boolean bl = this.agentOptions.stream().filter(string -> string.startsWith("destfile=")).findFirst().isPresent();
        if (!bl) {
            if (!JkUtilsString.isBlank((String)string2)) {
                string2 = string2 + ",";
            }
            string2 = string2 + "destfile=" + JkUtilsPath.relativizeFromWorkingDir((Path)this.execFile);
        }
        return string2;
    }

    public void generateExport() {
        JkLog.info((String)("Jacoco internal report created at " + this.execFile.toAbsolutePath().normalize()), (Object[])new Object[0]);
        if (!this.reportOptions.isEmpty()) {
            if (this.classDir == null) {
                JkLog.warn((String)"No class dir specified. Cannot run jacoco report.", (Object[])new Object[0]);
                return;
            }
            if (!Files.exists(this.execFile, new LinkOption[0])) {
                JkLog.warn((String)("File " + this.execFile + " not found. Cannot run jacoco report."), (Object[])new Object[0]);
                return;
            }
            JkPathTree jkPathTree = null;
            if (this.classDirFilter != null) {
                jkPathTree = JkPathTree.of((Path)this.classDir).withMatcher(this.classDirFilter);
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("report");
            linkedList.add(this.execFile.toString());
            if (this.classDirFilter == null) {
                linkedList.add("--classfiles");
                linkedList.add(this.classDir.toString());
            } else {
                jkPathTree.getFiles().forEach(object -> {
                    linkedList.add("--classfiles");
                    linkedList.add(object.toString());
                });
            }
            for (Path path : this.sourceDirs) {
            }
            linkedList.add("--encoding");
            linkedList.add("utf-8");
            linkedList.addAll(this.reportOptions);
            if (!JkLog.isVerbose()) {
                linkedList.add("--quiet");
            }
            JkLog.info((String)("Generate Jacoco XML report with args " + linkedList), (Object[])new Object[0]);
            ((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJavaJar((Path)this.toolProvider.getCmdLineJar(), null).setFailOnError(true)).setLogCommand(JkLog.isVerbose())).addParams(linkedList)).exec(new String[0]);
        }
    }

    public RepoToolProvider getToolProvider() {
        return this.toolProvider;
    }

    public Path getExecFile() {
        return this.execFile;
    }

    public static class RepoToolProvider {
        JkDependencyResolver dependencyResolver;
        String version;

        RepoToolProvider(JkDependencyResolver jkDependencyResolver, String string) {
            this.dependencyResolver = jkDependencyResolver;
            this.version = string;
        }

        public Path getAgentJar() {
            return JkCoordinateFileProxy.of((JkRepoSet)this.dependencyResolver.getRepos(), (String)("org.jacoco:org.jacoco.agent:runtime:" + this.version)).get();
        }

        public Path getCmdLineJar() {
            return JkCoordinateFileProxy.of((JkRepoSet)this.dependencyResolver.getRepos(), (String)("org.jacoco:org.jacoco.cli:nodeps:" + this.version)).get();
        }
    }
}

