/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.jacoco.JkJacoco;

@JkDoc(value={"Run unit tests with Jacoco agent coverage test tool."})
public class JacocoJkBean
extends JkBean {
    public static final String OUTPUT_RELATIVE_PATH = "jacoco/jacoco.exec";
    public static final String OUTPUT_XML_RELATIVE_PATH = "jacoco/jacoco.xml";
    @JkDoc(value={"If false, tests will be run without Jacoco."})
    public boolean enabled = true;
    @JkDoc(value={"If true, Jacoco will produce a standard XML report usable by Sonarqube."})
    public boolean xmlReport = true;
    @JkDoc(value={"Options string, as '[option1]=[value1],[option2]=[value2]', to pass to agent as described here : https://www.jacoco.org/jacoco/trunk/doc/agent.html"})
    public String agentOptions;
    @JkDoc(value={"Exclusion patterns separated with ',' to exclude some class files from the XML report input. An example is 'META-INF/**/*.jar'."})
    public String classDirExcludes;
    @JkDoc(value={"Version of Jacoco to use both for agent and report."})
    public String jacocoVersion = "0.8.7";
    private ProjectJkBean projectPlugin = ((ProjectJkBean)this.getRuntime().getBean(ProjectJkBean.class)).configure(this::configure);

    private void configure(JkProject jkProject) {
        if (!this.enabled) {
            return;
        }
        JkJacoco jkJacoco = JkUtilsString.isBlank((String)this.jacocoVersion) ? JkJacoco.ofEmbedded() : JkJacoco.ofManaged(jkProject.getConstruction().getDependencyResolver(), this.jacocoVersion);
        jkJacoco.setExecFile(jkProject.getOutputDir().resolve(OUTPUT_RELATIVE_PATH)).setClassDir(jkProject.getConstruction().getCompilation().getLayout().getClassDirPath());
        if (this.xmlReport) {
            jkJacoco.addReportOptions("--xml", jkProject.getOutputDir().resolve(OUTPUT_XML_RELATIVE_PATH).toString());
        }
        if (!JkUtilsString.isBlank((String)this.classDirExcludes)) {
            JkPathMatcher jkPathMatcher = JkPathMatcher.of((boolean)false, (String[])this.classDirExcludes.split(","));
            jkJacoco.setClassDirFilter(jkPathMatcher);
        }
        if (!JkUtilsString.isBlank((String)this.agentOptions)) {
            jkJacoco.addAgentOptions(this.agentOptions.split(","));
        }
        jkJacoco.configure(jkProject.getConstruction().getTesting().getTestProcessor());
    }
}

