/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkInternalEmbeddedClassloader;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.testing.JkTestProcessor;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.plugins.jacoco.JacocoJkBean;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class JkJacoco {
    private final ToolProvider toolProvider;
    private Path execFile;
    private Path classDir;
    private JkPathMatcher classDirFilter;
    private final List<String> agentOptions = new LinkedList<String>();
    private final List<String> reportOptions = new LinkedList<String>();

    private JkJacoco(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    public static JkJacoco ofEmbedded() {
        return new JkJacoco(new EmbeddedToolProvider());
    }

    public static JkJacoco ofManaged(JkDependencyResolver jkDependencyResolver, String string) {
        return new JkJacoco(new RepoToolProvider(jkDependencyResolver, string));
    }

    public static JkJacoco ofManaged(JkRepoSet jkRepoSet, String string) {
        return JkJacoco.ofManaged(JkDependencyResolver.of().addRepos(jkRepoSet), string);
    }

    public static JkJacoco ofManaged(String string) {
        return JkJacoco.ofManaged(JkRepo.ofMavenCentral().toSet(), string);
    }

    public JkJacoco setExecFile(Path path) {
        this.execFile = path;
        return this;
    }

    public JkJacoco addAgentOptions(String ... stringArray) {
        this.agentOptions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public JkJacoco setClassDir(Path path) {
        this.classDir = path;
        return this;
    }

    public JkJacoco setClassDirFilter(JkPathMatcher jkPathMatcher) {
        this.classDirFilter = jkPathMatcher;
        return this;
    }

    public JkJacoco addReportOptions(String ... stringArray) {
        this.reportOptions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public List<String> getReportOptions() {
        return this.reportOptions;
    }

    public void configure(JkTestProcessor jkTestProcessor) {
        JkUtilsAssert.state((this.execFile != null ? 1 : 0) != 0, (String)"The exec file has not been specified.", (Object[])new Object[0]);
        jkTestProcessor.getPreActions().append(() -> {
            String string = this.agentOptions();
            JkJavaProcess jkJavaProcess = (JkJavaProcess)JkUtilsObject.firstNonNull((Object[])new JkJavaProcess[]{jkTestProcessor.getForkingProcess(), JkJavaProcess.ofJava((String)JkTestProcessor.class.getName())});
            jkJavaProcess.addAgent(this.toolProvider.getAgentJar(), string);
            JkLog.info((String)("Instrumenting tests with Jacoco agent " + string), (Object[])new Object[0]);
            jkTestProcessor.setForkingProcess(jkJavaProcess);
            jkTestProcessor.getPostActions().append((Runnable)new Reporter());
        });
    }

    private String agentOptions() {
        String string2 = String.join((CharSequence)",", this.agentOptions);
        boolean bl = this.agentOptions.stream().filter(string -> string.startsWith("destfile=")).findFirst().isPresent();
        if (!bl) {
            if (!JkUtilsString.isBlank((String)string2)) {
                string2 = string2 + ",";
            }
            string2 = string2 + "destfile=" + JkUtilsPath.relativizeFromWorkingDir((Path)this.execFile);
        }
        return string2;
    }

    private static class EmbeddedToolProvider
    implements ToolProvider {
        private Path agentJarFile;
        private Path cliJarFile;

        EmbeddedToolProvider() {
            URL uRL = JacocoJkBean.class.getResource("org.jacoco.agent-0.8.7-runtime.jar");
            this.agentJarFile = JkUtilsIO.copyUrlContentToCacheFile((URL)uRL, (PrintStream)System.out, (Path)JkInternalEmbeddedClassloader.URL_CACHE_DIR);
            URL uRL2 = JacocoJkBean.class.getResource("org.jacoco.cli-0.8.7-nodeps.jar");
            this.cliJarFile = JkUtilsIO.copyUrlContentToCacheFile((URL)uRL2, (PrintStream)System.out, (Path)JkInternalEmbeddedClassloader.URL_CACHE_DIR);
        }

        @Override
        public Path getAgentJar() {
            return this.agentJarFile;
        }

        @Override
        public Path getCmdLineJar() {
            return this.cliJarFile;
        }
    }

    private static class RepoToolProvider
    implements ToolProvider {
        JkDependencyResolver dependencyResolver;
        String version;

        RepoToolProvider(JkDependencyResolver jkDependencyResolver, String string) {
            this.dependencyResolver = jkDependencyResolver;
            this.version = string;
        }

        @Override
        public Path getAgentJar() {
            return (Path)this.dependencyResolver.resolve(JkDependencySet.of((String)("org.jacoco:org.jacoco.agent:runtime:" + this.version))).getFiles().getEntries().get(0);
        }

        @Override
        public Path getCmdLineJar() {
            return (Path)this.dependencyResolver.resolve(JkDependencySet.of().and("org.jacoco:org.jacoco.cli:nodeps:" + this.version, JkTransitivity.NONE)).getFiles().getEntries().get(0);
        }
    }

    private static interface ToolProvider {
        public Path getAgentJar();

        public Path getCmdLineJar();
    }

    private class Reporter
    implements Runnable {
        private Reporter() {
        }

        @Override
        public void run() {
            JkLog.info((String)("Jacoco internal report created at " + JkJacoco.this.execFile.toAbsolutePath()), (Object[])new Object[0]);
            if (!JkJacoco.this.reportOptions.isEmpty()) {
                if (JkJacoco.this.classDir == null) {
                    JkLog.warn((String)"No class dir specified. Cannot run jacoco report.", (Object[])new Object[0]);
                    return;
                }
                if (!Files.exists(JkJacoco.this.execFile, new LinkOption[0])) {
                    JkLog.warn((String)("File " + JkJacoco.this.execFile + " not found. Cannot run jacoco report."), (Object[])new Object[0]);
                    return;
                }
                JkPathTree jkPathTree = null;
                if (JkJacoco.this.classDirFilter != null) {
                    jkPathTree = JkPathTree.of((Path)JkJacoco.this.classDir).withMatcher(JkJacoco.this.classDirFilter);
                }
                LinkedList<String> linkedList = new LinkedList<String>();
                linkedList.add("report");
                linkedList.add(JkJacoco.this.execFile.toString());
                if (JkJacoco.this.classDirFilter == null) {
                    linkedList.add("--classfiles");
                    linkedList.add(JkJacoco.this.classDir.toString());
                } else {
                    jkPathTree.getFiles().forEach(path -> {
                        linkedList.add("--classfiles");
                        linkedList.add(path.toString());
                    });
                }
                linkedList.add("--encoding");
                linkedList.add("utf-8");
                linkedList.addAll(JkJacoco.this.reportOptions);
                if (!JkLog.isVerbose()) {
                    linkedList.add("--quiet");
                }
                JkLog.info((String)"Generate Jacoco report", (Object[])new Object[0]);
                ((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJavaJar((Path)JkJacoco.this.toolProvider.getCmdLineJar(), null).setFailOnError(true)).setLogCommand(JkLog.isVerbose())).addParams(linkedList)).exec(new String[0]);
            }
        }
    }
}

