/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.depmanagement.JkCoordinateFileProxy;
import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkInternalEmbeddedClassloader;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.testing.JkTestProcessor;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class JkJacoco {
    public static final String OUTPUT_RELATIVE_PATH = "jacoco/jacoco.exec";
    public static final String OUTPUT_XML_RELATIVE_PATH = "jacoco/jacoco.xml";
    public static final String OUTPUT_HTML_RELATIVE_PATH = "jacoco/html";
    public static final String DEFAULT_VERSION = "0.8.11";
    private final ToolProvider toolProvider;
    private Path execFile;
    private Path classDir;
    private JkPathMatcher classDirFilter;
    private boolean htmlReport = true;
    private boolean xmlReport = true;
    private List<Path> sourceDirs = new LinkedList<Path>();
    private final List<String> agentOptions = new LinkedList<String>();
    private final List<String> reportOptions = new LinkedList<String>();

    private JkJacoco(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    public static JkJacoco ofVersion(JkDependencyResolver dependencyResolver, @JkDepSuggest(versionOnly=true, hint="org.jacoco:org.jacoco.agent") String version) {
        return new JkJacoco(new RepoToolProvider(dependencyResolver, version));
    }

    public static JkJacoco ofVersion(JkRepoSet repos, @JkDepSuggest(versionOnly=true, hint="org.jacoco:org.jacoco.agent") String version) {
        return JkJacoco.ofVersion(JkDependencyResolver.of((JkRepoSet)repos), version);
    }

    public static JkJacoco ofVersion(@JkDepSuggest(versionOnly=true, hint="org.jacoco:org.jacoco.agent") String version) {
        return JkJacoco.ofVersion(JkRepo.ofMavenCentral().toSet(), version);
    }

    public static JkJacoco ofEmbedded() {
        return new JkJacoco(new EmbeddedToolProvider());
    }

    public JkJacoco configureFor(JkProject project) {
        this.setExecFile(project.getOutputDir().resolve(OUTPUT_RELATIVE_PATH)).setClassDir(project.compilation.layout.getClassDirPath());
        if (this.xmlReport) {
            this.addReportOptions("--xml", project.getOutputDir().resolve(OUTPUT_XML_RELATIVE_PATH).toString());
        }
        if (this.htmlReport) {
            this.addReportOptions("--html", project.getOutputDir().resolve(OUTPUT_HTML_RELATIVE_PATH).toString());
        }
        List<Path> sourceDirs = project.compilation.layout.getSources().getRootDirsOrZipFiles().stream().map(path -> path.isAbsolute() ? path : project.getBaseDir().resolve((Path)path)).collect(Collectors.toList());
        this.setSources(sourceDirs);
        return this;
    }

    public JkJacoco configureForAndApplyTo(JkProject project) {
        this.configureFor(project).applyTo(project.testing.testProcessor);
        return this;
    }

    public void applyTo(JkTestProcessor testProcessor) {
        JkUtilsAssert.state((this.execFile != null ? 1 : 0) != 0, (String)"The exec file has not been specified.", (Object[])new Object[0]);
        testProcessor.preActions.append(() -> {
            String agentOptions = this.agentOptions();
            JkJavaProcess process = (JkJavaProcess)JkUtilsObject.firstNonNull((Object[])new JkJavaProcess[]{testProcessor.getForkingProcess(), JkJavaProcess.ofJava((String)JkTestProcessor.class.getName())});
            process.addAgent(this.toolProvider.getAgentJar(), agentOptions);
            JkLog.info((String)("Instrumenting tests with Jacoco agent options : " + agentOptions), (Object[])new Object[0]);
            testProcessor.setForkingProcess(process);
            testProcessor.postActions.append(this::generateExport);
        });
    }

    public JkJacoco setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
        return this;
    }

    public JkJacoco setXmlReport(boolean xmlReport) {
        this.xmlReport = xmlReport;
        return this;
    }

    public JkJacoco setExecFile(Path destFile) {
        this.execFile = destFile;
        return this;
    }

    public JkJacoco addAgentOptions(String ... args) {
        this.agentOptions.addAll(Arrays.asList(args));
        return this;
    }

    public JkJacoco setClassDir(Path classDir) {
        this.classDir = classDir;
        return this;
    }

    public JkJacoco setClassDirFilter(JkPathMatcher pathMatcher) {
        this.classDirFilter = pathMatcher;
        return this;
    }

    public JkJacoco setClassDirFilter(String pathDirExcludes) {
        JkPathMatcher pathMatcher;
        this.classDirFilter = pathMatcher = JkPathMatcher.of((boolean)false, (String[])pathDirExcludes.split(","));
        return this;
    }

    public JkJacoco addReportOptions(String ... args) {
        this.reportOptions.addAll(Arrays.asList(args));
        return this;
    }

    public JkJacoco setSources(List<Path> sourceDirs) {
        this.sourceDirs = sourceDirs;
        return this;
    }

    public List<String> getReportOptions() {
        return this.reportOptions;
    }

    public void generateExport() {
        JkLog.info((String)("Jacoco internal report created at " + this.execFile.toAbsolutePath().normalize()), (Object[])new Object[0]);
        if (!this.reportOptions.isEmpty()) {
            if (this.classDir == null) {
                JkLog.warn((String)"No class dir specified. Cannot run jacoco report.", (Object[])new Object[0]);
                return;
            }
            if (!Files.exists(this.execFile, new LinkOption[0])) {
                JkLog.warn((String)("File " + this.execFile + " not found. Cannot run jacoco report."), (Object[])new Object[0]);
                return;
            }
            JkPathTree pathTree = null;
            if (this.classDirFilter != null) {
                pathTree = JkPathTree.of((Path)this.classDir).withMatcher(this.classDirFilter);
            }
            LinkedList<String> args = new LinkedList<String>();
            args.add("report");
            args.add(this.execFile.toString());
            if (this.classDirFilter == null) {
                args.add("--classfiles");
                args.add(this.classDir.toString());
            } else {
                pathTree.getFiles().forEach(file -> {
                    args.add("--classfiles");
                    args.add(file.toString());
                });
            }
            for (Path path : this.sourceDirs) {
            }
            args.add("--encoding");
            args.add("utf-8");
            args.addAll(this.reportOptions);
            if (!JkLog.isVerbose()) {
                args.add("--quiet");
            }
            JkLog.info((String)("Generate Jacoco XML report with args " + args), (Object[])new Object[0]);
            ((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJavaJar((Path)this.toolProvider.getCmdLineJar(), null).setFailOnError(true)).setLogCommand(JkLog.isVerbose())).addParams(args)).exec(new String[0]);
        }
    }

    public Path getAgentJar() {
        return this.getToolProvider().getAgentJar();
    }

    public Path getExecFile() {
        return this.execFile;
    }

    private ToolProvider getToolProvider() {
        return this.toolProvider;
    }

    private JkPathTree pathTree() {
        JkUtilsAssert.state((this.classDir != null ? 1 : 0) != 0, (String)"Class dir has not been specified.", (Object[])new Object[0]);
        JkPathTree result = JkPathTree.of((Path)this.classDir);
        if (this.classDirFilter != null) {
            result = result.withMatcher(this.classDirFilter);
        }
        return result;
    }

    private String agentOptions() {
        String result = String.join((CharSequence)",", this.agentOptions);
        boolean hasDestFile = this.agentOptions.stream().filter(option -> option.startsWith("destfile=")).findFirst().isPresent();
        if (!hasDestFile) {
            if (!JkUtilsString.isBlank((String)result)) {
                result = result + ",";
            }
            result = result + "destfile=" + JkUtilsPath.relativizeFromWorkingDir((Path)this.execFile);
        }
        return result;
    }

    private static class EmbeddedToolProvider
    implements ToolProvider {
        private final Path agentJarFile;
        private final Path cliJarFile;

        EmbeddedToolProvider() {
            URL agentJarUrl = JkJacoco.class.getResource("org.jacoco.agent-0.8.7-runtime.jar");
            this.agentJarFile = JkUtilsIO.copyUrlContentToCacheFile((URL)agentJarUrl, (PrintStream)System.out, (Path)JkInternalEmbeddedClassloader.URL_CACHE_DIR);
            URL cliJarUrl = JkJacoco.class.getResource("org.jacoco.cli-0.8.7-nodeps.jar");
            this.cliJarFile = JkUtilsIO.copyUrlContentToCacheFile((URL)cliJarUrl, (PrintStream)System.out, (Path)JkInternalEmbeddedClassloader.URL_CACHE_DIR);
        }

        @Override
        public Path getAgentJar() {
            return this.agentJarFile;
        }

        @Override
        public Path getCmdLineJar() {
            return this.cliJarFile;
        }
    }

    public static class RepoToolProvider
    implements ToolProvider {
        JkDependencyResolver dependencyResolver;
        String version;

        RepoToolProvider(JkDependencyResolver dependencyResolver, String version) {
            this.dependencyResolver = dependencyResolver;
            this.version = version;
        }

        @Override
        public Path getAgentJar() {
            return JkCoordinateFileProxy.of((JkRepoSet)this.dependencyResolver.getRepos(), (String)("org.jacoco:org.jacoco.agent:runtime:" + this.version)).get();
        }

        @Override
        public Path getCmdLineJar() {
            return JkCoordinateFileProxy.of((JkRepoSet)this.dependencyResolver.getRepos(), (String)("org.jacoco:org.jacoco.cli:nodeps:" + this.version)).get();
        }
    }

    private static interface ToolProvider {
        public Path getAgentJar();

        public Path getCmdLineJar();
    }
}

