/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.jacoco.JkJacoco;

@JkDoc(value={"Run unit tests with Jacoco agent coverage test tool."})
public class JacocoJkBean
extends JkBean {
    @JkDoc(value={"If true, project from ProjectJkBean will be configured with Jacoco automatically."})
    public boolean configureProject = true;
    @JkDoc(value={"If true, Jacoco will produce a standard XML report usable by Sonarqube."})
    public boolean xmlReport = true;
    @JkDoc(value={"If true, Jacoco will produce a standard HTML report ."})
    public boolean htmlReport = true;
    @JkDoc(value={"Options string, as '[option1]=[value1],[option2]=[value2]', to pass to agent as described here : https://www.jacoco.org/jacoco/trunk/doc/agent.html"})
    public String agentOptions;
    @JkDoc(value={"Exclusion patterns separated with ',' to exclude some class files from the XML report input. An example is 'META-INF/**/*.jar'."})
    public String classDirExcludes;
    @JkDoc(value={"Version of Jacoco to use both for agent and report. The version will be resolved against coordinate 'org.jacoco:org.jacoco.agent:runtime'"})
    @JkDepSuggest(versionOnly=true, hint="org.jacoco:org.jacoco.agent:runtime")
    public String jacocoVersion = "0.8.7";

    private JacocoJkBean() {
        ((ProjectJkBean)this.getRuntime().getBean(ProjectJkBean.class)).lately(this::configureForDefaultProject);
    }

    private void configureForDefaultProject(JkProject project) {
        if (!this.configureProject) {
            return;
        }
        this.configure(project);
    }

    private void configure(JkProject project) {
        JkJacoco jacoco = JkJacoco.ofVersion(project.dependencyResolver, this.jacocoVersion).setHtmlReport(this.htmlReport).setXmlReport(this.xmlReport);
        if (!JkUtilsString.isBlank((String)this.classDirExcludes)) {
            jacoco.setClassDirFilter(this.classDirExcludes);
        }
        if (!JkUtilsString.isBlank((String)this.agentOptions)) {
            jacoco.addAgentOptions(this.agentOptions.split(","));
        }
        jacoco.configureForAndApplyTo(project);
    }
}

