/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.jacoco;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.jacoco.JkJacoco;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

@JkDoc(value={"Run unit tests with Jacoco agent coverage test tool."})
public class JacocoJkBean
extends JkBean {
    public static final String OUTPUT_RELATIVE_PATH = "jacoco/jacoco.exec";
    public static final String OUTPUT_XML_RELATIVE_PATH = "jacoco/jacoco.xml";
    public static final String OUTPUT_HTML_RELATIVE_PATH = "jacoco/html";
    @JkDoc(value={"If true, project from ProjectJkBean will be configured with Jacoco automatically."})
    public boolean configureProject = true;
    @JkDoc(value={"If true, Jacoco will produce a standard XML report usable by Sonarqube."})
    public boolean xmlReport = true;
    @JkDoc(value={"If true, Jacoco will produce a standard HTML report ."})
    public boolean htmlReport = false;
    @JkDoc(value={"Options string, as '[option1]=[value1],[option2]=[value2]', to pass to agent as described here : https://www.jacoco.org/jacoco/trunk/doc/agent.html"})
    public String agentOptions;
    @JkDoc(value={"Exclusion patterns separated with ',' to exclude some class files from the XML report input. An example is 'META-INF/**/*.jar'."})
    public String classDirExcludes;
    @JkDoc(value={"Version of Jacoco to use both for agent and report. The version will be resolved against coordinate 'org.jacoco:org.jacoco.agent:runtime'"})
    @JkDepSuggest(versionOnly=true, hint="org.jacoco:org.jacoco.agent:runtime")
    public String jacocoVersion = "0.8.7";
    private JkJacoco jacoco;

    public JacocoJkBean generateExport() {
        this.jacoco.generateExport();
        return this;
    }

    private JacocoJkBean() {
        ((ProjectJkBean)this.getRuntime().getBean(ProjectJkBean.class)).configure(this::configureForDefaultProject);
    }

    private void configureForDefaultProject(JkProject jkProject) {
        if (!this.configureProject) {
            return;
        }
        this.configure(jkProject);
    }

    public void configure(JkProject jkProject) {
        Object object;
        this.jacoco = JkJacoco.ofManaged(jkProject.dependencyResolver, this.jacocoVersion);
        this.jacoco.setExecFile(jkProject.getOutputDir().resolve(OUTPUT_RELATIVE_PATH)).setClassDir(jkProject.compilation.layout.getClassDirPath());
        if (this.xmlReport) {
            this.jacoco.addReportOptions("--xml", jkProject.getOutputDir().resolve(OUTPUT_XML_RELATIVE_PATH).toString());
        }
        if (this.htmlReport) {
            this.jacoco.addReportOptions("--html", jkProject.getOutputDir().resolve(OUTPUT_HTML_RELATIVE_PATH).toString());
        }
        if (!JkUtilsString.isBlank((String)this.classDirExcludes)) {
            object = JkPathMatcher.of((boolean)false, (String[])this.classDirExcludes.split(","));
            this.jacoco.setClassDirFilter((JkPathMatcher)object);
        }
        if (!JkUtilsString.isBlank((String)this.agentOptions)) {
            this.jacoco.addAgentOptions(this.agentOptions.split(","));
        }
        this.jacoco.configure(jkProject.testing.testProcessor);
        object = jkProject.compilation.layout.getSources().getRootDirsOrZipFiles().stream().map(path -> path.isAbsolute() ? path : jkProject.getBaseDir().resolve((Path)path)).collect(Collectors.toList());
        this.jacoco.setSources((List<Path>)object);
    }

    public JacocoJkBean setConfigureProject(boolean bl) {
        this.configureProject = bl;
        return this;
    }

    public JacocoJkBean setXmlReport(boolean bl) {
        this.xmlReport = bl;
        return this;
    }

    public JacocoJkBean setHtmlReport(boolean bl) {
        this.htmlReport = bl;
        return this;
    }

    public JacocoJkBean setClassDirExcludes(String string) {
        this.classDirExcludes = string;
        return this;
    }

    public JacocoJkBean setJacocoVersion(String string) {
        this.jacocoVersion = string;
        return this;
    }

    public AgentJarAndReportFile getAgentAndReportFile() {
        JkUtilsAssert.state((this.jacoco != null ? 1 : 0) != 0, (String)"This method cannot be invoked when no project has been configured on.", (Object[])new Object[0]);
        return new AgentJarAndReportFile(this.jacoco.getToolProvider().getAgentJar(), this.jacoco.getExecFile());
    }

    public static class AgentJarAndReportFile {
        private final Path agentPath;
        private final Path reportFile;

        AgentJarAndReportFile(Path path, Path path2) {
            this.agentPath = path;
            this.reportFile = path2;
        }

        public Path getAgentPath() {
            return this.agentPath;
        }

        public Path getReportFile() {
            return this.reportFile;
        }
    }
}

