/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.javatools.maputils.helpers.Constants;
import dev.javatools.maputils.helpers.MapUtilsException;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapSort {
    private static final String EMPTY_STRING = "";
    private static final String PERIOD = ".";
    private static final String LIST_SYMBOL = "[]";
    private Logger logger = LoggerFactory.getLogger(MapSort.class);

    private MapSort() {
    }

    public static Map getSortedMap(Map input) {
        if (null == input) {
            return new HashMap();
        }
        HashMap<String, String> listKeys = new HashMap<String, String>();
        return MapSort.getSortedMap(input, listKeys);
    }

    public static Map getSortedMap(Map input, Map<String, String> listKeys) {
        try {
            if (null == input) {
                return new HashMap();
            }
            HashMap<String, String> listKeysInternal = new HashMap<String, String>();
            if (null != listKeys) {
                listKeysInternal.putAll(listKeys);
            }
            String jsonString = Constants.jsonMapper.writeValueAsString((Object)input);
            Map sanitizedMap = (Map)Constants.jsonMapper.readValue(jsonString, Map.class);
            return MapSort.getSortedMap(sanitizedMap, listKeysInternal, null);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new MapUtilsException(jsonProcessingException);
        }
    }

    private static Map getSortedMap(Map input, Map<String, String> listKeys, String prefix) {
        TreeMap treeMap = new TreeMap();
        MapSort mapSort = new MapSort();
        for (Map.Entry item : input.entrySet()) {
            Map.Entry entry = item;
            if (entry.getValue() instanceof Map) {
                mapSort.processMap(entry, treeMap, listKeys, prefix);
                continue;
            }
            if (entry.getValue() instanceof List) {
                mapSort.processList(entry, treeMap, listKeys, prefix);
                continue;
            }
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    private void processMap(Map.Entry entry, TreeMap treeMap, Map<String, String> listKeys, String prefix) {
        Object updatedPrefix = null == prefix ? EMPTY_STRING : prefix + PERIOD;
        Map innerMap = MapSort.getSortedMap((Map)entry.getValue(), listKeys, (String)updatedPrefix + entry.getKey());
        treeMap.put(entry.getKey(), innerMap);
    }

    private void processList(Map.Entry entry, Map treeMap, Map<String, String> listKeys, String prefix) {
        String updatedPrefix = null == prefix ? entry.getKey() + LIST_SYMBOL : prefix + PERIOD + entry.getKey() + LIST_SYMBOL;
        List sortedSet = this.getSortedList((List)entry.getValue(), listKeys, updatedPrefix);
        treeMap.put(entry.getKey(), sortedSet);
    }

    private void processList(Object entry, Set<Object> treeSet, Map<String, String> listKeys, String prefix) {
        Object updatedPrefix = null == prefix ? LIST_SYMBOL : prefix + LIST_SYMBOL;
        List sortedSet = this.getSortedList((List)entry, listKeys, (String)updatedPrefix);
        treeSet.add(sortedSet);
    }

    private List getSortedList(List input, Map<String, String> listKeys, String prefix) {
        AbstractSet response = null;
        for (Object currentItem : input) {
            this.logger.debug(currentItem.getClass().getName());
            if (currentItem instanceof Map) {
                if (response == null) {
                    response = new HashSet();
                }
                response.add(MapSort.getSortedMap((Map)currentItem, listKeys, prefix));
                continue;
            }
            if (currentItem instanceof List) {
                if (response == null) {
                    response = new HashSet();
                }
                this.processList(currentItem, response, listKeys, prefix);
                continue;
            }
            if (response == null) {
                response = new TreeSet();
            }
            response.add(currentItem);
        }
        if (null == response) {
            response = new TreeSet<Map>();
        }
        if (listKeys.containsKey(prefix) && response instanceof HashSet) {
            return response.stream().sorted(Comparator.comparing(innerMap -> (String)((Map)innerMap).get(listKeys.get(prefix)))).collect(Collectors.toList());
        }
        return response.stream().collect(Collectors.toList());
    }
}

