/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import dev.javatools.maputils.helpers.MapUtilsException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class MapProperty {
    private static final String PATH_DELIMITER_REGEX = "[.]";
    private static final String LIST_MATCH = ".*\\[.*\\]";
    private static final String FILTER_MATCH = "\\{.*\\}";
    private static final String NUMBER_MATCH = "[0-9]+";
    private static final String OPEN_CURLY = "{";
    private static final String CLOSE_CURLY = "}";
    private static final String OPEN_SQUARE = "[";
    private static final String CLOSE_SQUARE = "]";
    private static final String EQUAL = "=";

    public static Object get(String fieldPath, Map sourceMap) {
        if (null != fieldPath) {
            String[] sourcePathArray = fieldPath.split(PATH_DELIMITER_REGEX);
            MapProperty mapProperty = new MapProperty();
            List<String> targetList = Arrays.asList(sourcePathArray);
            LinkedList<String> paths = new LinkedList<String>();
            paths.addAll(targetList);
            return mapProperty.get(paths, sourceMap);
        }
        return null;
    }

    private Object get(Queue<String> pathQueue, Map sourceMap) {
        Object currentValue = sourceMap;
        while (!pathQueue.isEmpty() && null != currentValue) {
            String currentElement = pathQueue.remove();
            if (currentElement.matches(LIST_MATCH)) {
                currentValue = this.processList(currentElement, (Map)currentValue);
                continue;
            }
            currentValue = currentValue.get(currentElement);
        }
        return currentValue;
    }

    private Object processList(String currentElement, Map sourceMap) {
        String filterCriteria = currentElement.substring(currentElement.lastIndexOf(OPEN_SQUARE) + 1, currentElement.lastIndexOf(CLOSE_SQUARE));
        String currentKey = currentElement.substring(0, currentElement.indexOf(OPEN_SQUARE));
        if (null == sourceMap.get(currentKey)) {
            return null;
        }
        if (!(sourceMap.get(currentKey) instanceof List)) {
            throw new MapUtilsException("Did not found list at property: " + currentElement);
        }
        Object listObject = sourceMap.get(currentKey);
        List list = (List)listObject;
        if (list.size() == 0) {
            return null;
        }
        if (filterCriteria.matches(FILTER_MATCH)) {
            List results = this.processFilterList(filterCriteria, list);
            if (results.size() > 0) {
                return results.get(0);
            }
            return null;
        }
        if (filterCriteria.matches(NUMBER_MATCH)) {
            return this.getNumberedElementFromList(list, Integer.parseInt(filterCriteria));
        }
        if (filterCriteria.equals("")) {
            return this.getFirstElementFromList(list);
        }
        throw new MapUtilsException("wrong filter criteria on list:" + currentElement);
    }

    private Object getFirstElementFromList(List sourceList) {
        return this.getNumberedElementFromList(sourceList, 0);
    }

    private Object getNumberedElementFromList(List sourceList, int itemPosition) {
        if (sourceList.size() > itemPosition) {
            return sourceList.get(itemPosition);
        }
        return null;
    }

    private List processFilterList(String filterCriteria, List<Map<String, Object>> sourceList) {
        LinkedList<Map<String, Object>> matchedElements = new LinkedList<Map<String, Object>>();
        Map<String, String> filters = this.getFilters(filterCriteria);
        for (Map<String, Object> currentMap : sourceList) {
            boolean match = true;
            for (Map.Entry<String, String> filterItem : filters.entrySet()) {
                if (null != currentMap.get(filterItem.getKey())) {
                    if (currentMap.get(filterItem.getKey()).equals(filterItem.getValue())) continue;
                    match = false;
                    break;
                }
                match = false;
                break;
            }
            if (!match) continue;
            matchedElements.add(currentMap);
        }
        return matchedElements;
    }

    private Map<String, String> getFilters(String originalFilters) {
        String[] filterArray;
        HashMap<String, String> filters = new HashMap<String, String>();
        for (String individualFilter : filterArray = originalFilters.split(CLOSE_CURLY)) {
            String[] keyValue;
            if (individualFilter.trim().indexOf(OPEN_CURLY) >= 0) {
                keyValue = (individualFilter = individualFilter.substring(individualFilter.indexOf(OPEN_CURLY) + 1)).split(EQUAL);
                if (keyValue.length != 2) {
                    throw new MapUtilsException("Not a valid filter: " + individualFilter);
                }
            } else {
                throw new MapUtilsException("Not a valid filter: " + individualFilter);
            }
            filters.put(keyValue[0], keyValue[1]);
        }
        return filters;
    }
}

