/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.javatools.maputils.helpers.Constants;
import dev.javatools.maputils.helpers.Format;
import dev.javatools.maputils.helpers.MapUtilsException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;

public final class MapCreator {
    private MapCreator() {
    }

    public static Map create(File input, Format format) {
        try {
            Path tempFilePath = Path.of(input.getAbsolutePath(), new String[0]);
            String jsonString = Files.readString(tempFilePath);
            return MapCreator.create(jsonString, format);
        }
        catch (IOException ioException) {
            throw new MapUtilsException(ioException);
        }
    }

    public static Map create(String input, Format format) {
        try {
            Map mapInput = format == Format.JSON ? (Map)Constants.jsonMapper.readValue(input, Map.class) : (Map)Constants.yamlMapper.readValue(input, Map.class);
            return mapInput;
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new MapUtilsException(jsonProcessingException);
        }
    }

    public static Map create(Object input) {
        try {
            String jsonString = Constants.jsonMapper.writeValueAsString(input);
            return (Map)Constants.jsonMapper.readValue(jsonString, Map.class);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new MapUtilsException(jsonProcessingException);
        }
    }
}

