/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import dev.javatools.maputils.MapProperties;
import java.util.Map;
import java.util.Set;

public final class MapCompare {
    private MapCompare() {
    }

    public static boolean equal(Map left, Map right) {
        if (null == left ^ null == right) {
            return false;
        }
        if (null == left && null == right) {
            return true;
        }
        Map<String, Object> leftProperties = MapProperties.getProperties(left);
        Map<String, Object> rightProperties = MapProperties.getProperties(right);
        if (null == rightProperties ^ null == leftProperties) {
            return false;
        }
        if (null == leftProperties && null == rightProperties) {
            return true;
        }
        Set<String> rightKeySet = rightProperties.keySet();
        if (leftProperties.size() != rightProperties.size()) {
            return false;
        }
        for (Map.Entry<String, Object> property : leftProperties.entrySet()) {
            Map.Entry entry = (Map.Entry)Map.Entry.class.cast(property);
            if (!rightKeySet.contains(entry.getKey())) {
                return false;
            }
            if (rightProperties.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

