/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import dev.javatools.maputils.MapSort;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class MapToProperties {
    private MapToProperties() {
    }

    public static Map<String, Object> getProperties(Map source) {
        TreeMap<String, Object> results = new TreeMap<String, Object>();
        Map treeMap = MapSort.getSortedMap(source);
        MapToProperties mapToProperties = new MapToProperties();
        mapToProperties.getProperties(treeMap, results, null);
        return results;
    }

    private void getProperties(Map source, Map paths, String pathPrefix) {
        Object currentPrefix = pathPrefix == null ? "" : pathPrefix + ".";
        for (Map.Entry item : source.entrySet()) {
            Map.Entry entry = item;
            if (entry.getValue() instanceof Map || entry.getValue() instanceof Set || entry.getValue() instanceof List) {
                this.processNextElement(entry.getValue(), paths, (String)currentPrefix + entry.getKey());
                continue;
            }
            paths.put((String)currentPrefix + entry.getKey(), entry.getValue());
        }
    }

    private void processNextElement(Object source, Map results, String pathPrefix) {
        if (source instanceof Map) {
            this.getProperties((Map)source, results, pathPrefix);
        } else if (source instanceof List) {
            this.processList((List)source, results, pathPrefix);
        } else {
            results.put(pathPrefix, source);
        }
    }

    private void processList(List source, Map paths, String pathPrefix) {
        String currentPrefix = pathPrefix == null ? "" : pathPrefix;
        int index = 0;
        if (source instanceof List) {
            for (Object currentListItem : source) {
                this.processNextElement(currentListItem, paths, currentPrefix + "[" + index++ + "]");
            }
        }
    }
}

