/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import dev.javatools.maputils.helpers.MapUtilsException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class MapUpdate {
    private static final String PATH_DELIMITER_REGEX = "[.]";
    private static final String LIST_INDICATOR = "[]";
    private static final String LIST_MATCH = ".*\\[.*\\]";
    private static final String FILTER_MATCH = "\\{.*\\}";
    private static final String NUMBER_MATCH = "[0-9]+";
    private static final String OPEN_CURLY = "{";
    private static final String CLOSE_CURLY = "}";
    private static final String OPEN_SQUARE = "[";
    private static final String CLOSE_SQUARE = "]";
    private static final String EQUAL = "=";

    public static Object get(String mapPath, Map map) {
        if (null != mapPath) {
            String[] sourcePathArray = mapPath.split(PATH_DELIMITER_REGEX);
            MapUpdate mapUpdate = new MapUpdate();
            return mapUpdate.get(sourcePathArray, map);
        }
        return null;
    }

    public static void set(String mapPath, Map sourceMap, Object value) {
        if (null == mapPath || null == sourceMap) {
            throw new MapUtilsException("Not a valid input, mapPath and sourceMap are mandatory fields.");
        }
        String[] sourcePathArray = mapPath.split(PATH_DELIMITER_REGEX);
        List<String> targetList = Arrays.asList(sourcePathArray);
        LinkedList<String> paths = new LinkedList<String>();
        paths.addAll(targetList);
        MapUpdate mapUpdate = new MapUpdate();
        mapUpdate.set(paths, sourceMap, value, null);
    }

    private Object get(String[] sourcePathArray, Map sourceMap) {
        try {
            if (sourcePathArray.length == 0 || sourceMap.get(sourcePathArray[0]) == null) {
                return null;
            }
            if (sourcePathArray.length > 1) {
                if (sourcePathArray[0].contains(LIST_INDICATOR) && sourceMap.get(sourcePathArray[0]) instanceof List) {
                    return sourceMap.get(sourcePathArray[0]);
                }
                if (!(sourceMap.get(sourcePathArray[0]) instanceof Map)) {
                    return null;
                }
                String[] subArray = Arrays.copyOfRange(sourcePathArray, 1, sourcePathArray.length);
                return this.get(subArray, (Map)sourceMap.get(sourcePathArray[0]));
            }
            return sourceMap.get(sourcePathArray[0]);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(Queue<String> pathQueue, Map sourceMap, Object fieldValue, String processPath) {
        String originalKey = pathQueue.remove();
        String newProcessPath = (String)(null == processPath ? "" : processPath + ".") + originalKey;
        if (!originalKey.matches(LIST_MATCH)) {
            if (pathQueue.size() > 0) {
                Object innerElement = sourceMap.get(originalKey.substring(0, originalKey.lastIndexOf(OPEN_SQUARE)));
                if (null != innerElement && innerElement instanceof Map) {
                    this.set(pathQueue, (Map)innerElement, fieldValue, newProcessPath);
                    return;
                } else {
                    if (null != innerElement) throw new MapUtilsException(originalKey + " is not a Map. Its object type is " + innerElement.getClass().getName() + ". At this time only maps and lists are supported.");
                    this.set(pathQueue, new HashMap(), fieldValue, newProcessPath);
                }
                return;
            } else if (fieldValue == null) {
                sourceMap.remove(originalKey);
                return;
            } else {
                sourceMap.put(originalKey, fieldValue);
            }
            return;
        } else {
            String actualKey = originalKey.substring(0, originalKey.lastIndexOf(OPEN_SQUARE));
            Object innerElement = sourceMap.get(actualKey);
            String filterCriteria = originalKey.substring(originalKey.lastIndexOf(OPEN_SQUARE), originalKey.lastIndexOf(CLOSE_SQUARE) + 1);
            if (null != innerElement) {
                if (!(innerElement instanceof List)) throw new MapUtilsException(newProcessPath + " is not a list. Its object type is " + innerElement.getClass().getName());
                this.set(pathQueue, (List)innerElement, fieldValue, filterCriteria, newProcessPath);
                return;
            } else {
                innerElement = new LinkedList();
                sourceMap.put(actualKey, innerElement);
                this.set(pathQueue, (List)innerElement, fieldValue, filterCriteria, newProcessPath);
            }
        }
    }

    private void set(Queue<String> pathQueue, List sourceList, Object fieldValue, String parameters, String processPath) {
        String innerParameters = parameters.substring(1, parameters.length() - 1);
        if (innerParameters.matches(FILTER_MATCH)) {
            String[] individualparameters = innerParameters.trim().split(CLOSE_CURLY);
            HashMap<String, String> filterCriteria = new HashMap<String, String>();
            for (String processCurrentParameter : individualparameters) {
                processCurrentParameter = processCurrentParameter.substring(processCurrentParameter.indexOf(OPEN_CURLY) + 1);
                String[] keyValue = processCurrentParameter.split(EQUAL);
                filterCriteria.put(keyValue[0].trim(), keyValue[1].trim());
            }
            for (Object currentElementObject : sourceList) {
                Map currentListElement = (Map)currentElementObject;
                boolean match = true;
                for (Map.Entry currentFilter : filterCriteria.entrySet()) {
                    if (currentListElement.containsKey(currentFilter.getKey()) && currentListElement.get(currentFilter.getKey()).toString().equals(currentFilter.getValue())) continue;
                    match = false;
                }
                if (!match || pathQueue.size() == 0 && null == fieldValue) continue;
                if (pathQueue.size() == 0) {
                    throw new MapUtilsException(processPath + ": Found the element in this path, but to assign the value, we also need a key.");
                }
                this.set(pathQueue, currentListElement, fieldValue, processPath);
            }
        } else if (innerParameters.matches(NUMBER_MATCH)) {
            int listLocation = Integer.parseInt(innerParameters);
            if (pathQueue.size() > 0) {
                if (sourceList.size() > listLocation && null != sourceList.get(listLocation)) {
                    this.set(pathQueue, (Map)sourceList.get(listLocation), fieldValue, processPath);
                } else {
                    if (sourceList.size() <= listLocation) {
                        for (int i = sourceList.size() + 1; i <= listLocation + 1; ++i) {
                            sourceList.add(new HashMap());
                        }
                    }
                    this.set(pathQueue, (Map)sourceList.get(listLocation), fieldValue, processPath);
                }
            } else {
                sourceList.add(fieldValue);
            }
        } else if (pathQueue.size() > 0) {
            if (sourceList.size() > 0 && null != sourceList.get(0)) {
                this.set(pathQueue, (Map)sourceList.get(0), fieldValue, processPath);
            } else {
                sourceList.add(0, new HashMap());
                this.set(pathQueue, (Map)sourceList.get(0), fieldValue, processPath);
            }
        } else if (fieldValue != null) {
            sourceList.add(fieldValue);
        }
    }
}

