/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.maputils;

import dev.javatools.maputils.MapSort;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class MapToPaths {
    private MapToPaths() {
    }

    public static Set<String> getPaths(Map input) {
        TreeSet<String> results = new TreeSet<String>();
        Map treeMap = MapSort.getSortedMap(input);
        MapToPaths mapToPaths = new MapToPaths();
        mapToPaths.getPaths(treeMap, results, null, false);
        return results;
    }

    public static Set<String> getUniquePaths(Map input) {
        TreeSet<String> results = new TreeSet<String>();
        Map treeMap = MapSort.getSortedMap(input);
        MapToPaths mapToPaths = new MapToPaths();
        mapToPaths.getPaths(treeMap, results, null, true);
        return results;
    }

    private void getPaths(Map source, Set<String> paths, String pathPrefix, boolean unique) {
        Object currentPrefix = pathPrefix == null ? "" : pathPrefix + ".";
        for (Map.Entry item : source.entrySet()) {
            Map.Entry entry = item;
            if (entry.getValue() instanceof Map || entry.getValue() instanceof Set || entry.getValue() instanceof List) {
                this.processNextElement(entry.getValue(), paths, (String)currentPrefix + entry.getKey(), unique);
                continue;
            }
            paths.add((String)currentPrefix + entry.getKey());
        }
    }

    private void processList(List source, Set<String> paths, String pathPrefix, boolean unique) {
        String currentPrefix = pathPrefix == null ? "" : pathPrefix;
        int index = 0;
        if (source instanceof List) {
            for (Object currentListItem : source) {
                if (unique) {
                    this.processNextElement(currentListItem, paths, currentPrefix + "[]", true);
                    continue;
                }
                this.processNextElement(currentListItem, paths, currentPrefix + "[" + index++ + "]", false);
            }
        }
    }

    private void processNextElement(Object source, Set<String> paths, String pathPrefix, boolean unique) {
        if (Map.class.isInstance(source)) {
            this.getPaths((Map)Map.class.cast(source), paths, pathPrefix, unique);
        } else if (source instanceof List) {
            this.processList((List)source, paths, pathPrefix, unique);
        } else {
            paths.add(pathPrefix);
        }
    }
}

