/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.jsonutils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.javatools.jsonutils.JsonUtilsException;
import dev.javatools.maputils.MapCreator;
import dev.javatools.maputils.MapSort;
import dev.javatools.maputils.helpers.Format;
import java.io.File;
import java.util.Map;

public class JsonSort {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String sort(String inputJson) {
        try {
            Map inputMap = MapCreator.create((String)inputJson, (Format)Format.JSON);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MapSort.getSortedMap((Map)inputMap));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }

    public static String sort(String inputJson, Map<String, String> listKeys) {
        try {
            Map inputMap = MapCreator.create((String)inputJson, (Format)Format.JSON);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MapSort.getSortedMap((Map)inputMap, listKeys));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }

    public static String sort(File inputJson) {
        try {
            Map inputMap = MapCreator.create((File)inputJson, (Format)Format.JSON);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MapSort.getSortedMap((Map)inputMap));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }

    public static String sort(File inputJson, Map<String, String> listKeys) {
        try {
            Map inputMap = MapCreator.create((File)inputJson, (Format)Format.JSON);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MapSort.getSortedMap((Map)inputMap, listKeys));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }

    public static String sort(Object inputJson) {
        try {
            Map inputMap = MapCreator.create((Object)inputJson);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MapSort.getSortedMap((Map)inputMap));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }

    public static String sort(Object inputJson, Map<String, String> listKeys) {
        try {
            Map inputMap = MapCreator.create((Object)inputJson);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MapSort.getSortedMap((Map)inputMap, listKeys));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }
}

