/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.jsonutils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.javatools.jsonutils.JsonUtilsException;
import dev.javatools.maputils.MapCreator;
import dev.javatools.maputils.MapProperties;
import dev.javatools.maputils.MapProperty;
import dev.javatools.maputils.MapUpdate;
import dev.javatools.maputils.helpers.Format;
import java.io.File;
import java.util.Map;

public class JsonProperty {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Map<String, Object> getAllProperties(String jsonString) {
        Map inputJson = MapCreator.create((String)jsonString, (Format)Format.JSON);
        return MapProperties.getProperties((Map)inputJson);
    }

    public static Map<String, Object> getAllProperties(File jsonFile) {
        Map inputJson = MapCreator.create((File)jsonFile, (Format)Format.JSON);
        return MapProperties.getProperties((Map)inputJson);
    }

    public static Map<String, Object> getAllProperties(Object customJavaModel) {
        Map inputJson = MapCreator.create((Object)customJavaModel);
        return MapProperties.getProperties((Map)inputJson);
    }

    public static Object getProperty(String jsonPath, String jsonString) {
        Map inputJson = MapCreator.create((String)jsonString, (Format)Format.JSON);
        return MapProperty.get((String)jsonPath, (Map)inputJson);
    }

    public static Object getProperty(String jsonPath, File jsonFile) {
        Map inputJson = MapCreator.create((File)jsonFile, (Format)Format.JSON);
        return MapProperty.get((String)jsonPath, (Map)inputJson);
    }

    public static Object getProperty(String jsonPath, Object customJavaModel) {
        Map inputJson = MapCreator.create((Object)customJavaModel);
        return MapProperty.get((String)jsonPath, (Map)inputJson);
    }

    public static String setProperty(String jsonPath, String jsonString, Object value) {
        try {
            if (null != jsonPath && null != jsonString) {
                Map inputMap = MapCreator.create((String)jsonString, (Format)Format.JSON);
                MapUpdate.set((String)jsonPath, (Map)inputMap, (Object)value);
                return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)inputMap);
            }
            throw new JsonUtilsException("Not a valid input, Json Path and Input Json are mandatory fields.");
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonUtilsException(jsonProcessingException);
        }
    }
}

