/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.map;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortMap {
    private static final String EMPTY_STRING = "";
    private static final String PERIOD = ".";
    private static final String LIST_SYMBOL = "[]";
    private Logger logger = LoggerFactory.getLogger(SortMap.class);

    public Map<String, Object> getSortedMap(Map<String, Object> input) {
        HashMap<String, String> listKeys = new HashMap<String, String>();
        return this.getSortedMap(input, listKeys);
    }

    public Map<String, Object> getSortedMap(Map<String, Object> input, Map<String, String> listKeys) {
        return this.getSortedMap(input, listKeys, null);
    }

    private Map<String, Object> getSortedMap(Map<String, Object> input, Map<String, String> listKeys, String prefix) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.processMap(entry, treeMap, listKeys, prefix);
                continue;
            }
            if (entry.getValue() instanceof List) {
                this.processList(entry, treeMap, listKeys, prefix);
                continue;
            }
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    private void processMap(Map.Entry<String, Object> entry, TreeMap<String, Object> treeMap, Map<String, String> listKeys, String prefix) {
        Object updatedPrefix = null == prefix ? EMPTY_STRING : prefix + PERIOD;
        Map<String, Object> innerMap = this.getSortedMap((Map)entry.getValue(), listKeys, (String)updatedPrefix + entry.getKey());
        treeMap.put(entry.getKey(), innerMap);
    }

    private void processList(Map.Entry<String, Object> entry, Map<String, Object> treeMap, Map<String, String> listKeys, String prefix) {
        String updatedPrefix = null == prefix ? entry.getKey() + LIST_SYMBOL : prefix + PERIOD + entry.getKey() + LIST_SYMBOL;
        List<Object> sortedSet = this.getSortedList((List)entry.getValue(), listKeys, updatedPrefix);
        treeMap.put(entry.getKey(), sortedSet);
    }

    private void processList(Object entry, Set<Object> treeSet, Map<String, String> listKeys, String prefix) {
        Object updatedPrefix = null == prefix ? LIST_SYMBOL : prefix + LIST_SYMBOL;
        List<Object> sortedSet = this.getSortedList((List)entry, listKeys, (String)updatedPrefix);
        treeSet.add(sortedSet);
    }

    private List<Object> getSortedList(List<Object> input, Map<String, String> listKeys, String prefix) {
        AbstractSet response = null;
        for (Object currentItem : input) {
            this.logger.debug(currentItem.getClass().getName());
            if (currentItem instanceof Map) {
                if (response == null) {
                    response = new HashSet<Object>();
                }
                response.add(this.getSortedMap((Map)currentItem, listKeys, prefix));
                continue;
            }
            if (currentItem instanceof List) {
                if (response == null) {
                    response = new HashSet();
                }
                this.processList(currentItem, response, listKeys, prefix);
                continue;
            }
            if (response == null) {
                response = new TreeSet();
            }
            response.add(currentItem);
        }
        if (listKeys.containsKey(prefix) && response instanceof HashSet) {
            return response.stream().sorted(Comparator.comparing(innerMap -> (String)((Map)innerMap).get(listKeys.get(prefix)))).collect(Collectors.toList());
        }
        return response.stream().collect(Collectors.toList());
    }
}

