/*
 * Decompiled with CFR 0.152.
 */
package dev.javatools.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.javatools.map.CreateMap;
import dev.javatools.map.SortMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class SortJson {
    private ObjectMapper objectMapper = new ObjectMapper();
    private CreateMap createMap = new CreateMap();

    public String getSortedJson(String input) throws JsonProcessingException {
        return this.getSortedJson(this.createMap.create(input));
    }

    public String getSortedJson(String input, Map<String, String> listKeys) throws JsonProcessingException {
        return this.getSortedJson(this.createMap.create(input), listKeys);
    }

    public String getSortedJson(File input) throws IOException {
        return this.getSortedJson(this.createMap.create(input));
    }

    public String getSortedJson(File input, Map<String, String> listKeys) throws IOException {
        return this.getSortedJson(this.createMap.create(input), listKeys);
    }

    public String getSortedJson(Object input) throws IOException {
        return this.getSortedJson(this.createMap.create(input));
    }

    public String getSortedJson(Object input, Map<String, String> listKeys) throws IOException {
        return this.getSortedJson(this.createMap.create(input), listKeys);
    }

    public String getSortedJson(Map<String, Object> input) throws JsonProcessingException {
        return this.getSortedJson(input, null);
    }

    private String getSortedJson(Map<String, Object> input, Map<String, String> listKeys) throws JsonProcessingException {
        SortMap sortMap = new SortMap();
        Map<String, Object> sorted = null == listKeys ? sortMap.getSortedMap(input) : sortMap.getSortedMap(input, listKeys);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(sorted);
    }
}

