/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import dev.jamesyox.kastro.util.ExtendedMath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0000J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u001f\u001a\u00020\u0003J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0003H\u0086\u0002J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006'"}, d2={"Ldev/jamesyox/kastro/util/Vector;", "", "x", "", "y", "z", "(DDD)V", "phi", "getPhi", "()D", "r", "getR", "theta", "getTheta", "getX", "getY", "getZ", "component1", "component2", "component3", "copy", "cross", "right", "dot", "equals", "", "other", "hashCode", "", "minus", "vec", "norm", "plus", "times", "scalar", "toString", "", "unaryMinus", "Companion", "kastro"})
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\ndev/jamesyox/kastro/util/Vector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class Vector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    /*
     * WARNING - void declaration
     */
    public final double getPhi() {
        void var1_1;
        double it = ExtendedMath.INSTANCE.isZero(this.x) && ExtendedMath.INSTANCE.isZero(this.y) ? 0.0 : Math.atan2(this.y, this.x);
        boolean bl = false;
        return it < 0.0 ? it + Math.PI * 2 : var1_1;
    }

    public final double getTheta() {
        double sqr = this.x * this.x + this.y * this.y;
        return ExtendedMath.INSTANCE.isZero(this.z) && ExtendedMath.INSTANCE.isZero(sqr) ? 0.0 : Math.atan2(this.z, Math.sqrt(sqr));
    }

    public final double getR() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @NotNull
    public final Vector plus(@NotNull Vector vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return new Vector(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    @NotNull
    public final Vector minus(@NotNull Vector vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return new Vector(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    @NotNull
    public final Vector times(double scalar) {
        return new Vector(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    @NotNull
    public final Vector unaryMinus() {
        return new Vector(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final Vector cross(@NotNull Vector right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Vector(this.y * right.z - this.z * right.y, this.z * right.x - this.x * right.z, this.x * right.y - this.y * right.x);
    }

    public final double dot(@NotNull Vector right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return this.x * right.x + this.y * right.y + this.z * right.z;
    }

    public final double norm() {
        return Math.sqrt(this.dot(this));
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Vector copy(double x, double y, double z) {
        return new Vector(x, y, z);
    }

    public static /* synthetic */ Vector copy$default(Vector vector, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector.x;
        }
        if ((n & 2) != 0) {
            d2 = vector.y;
        }
        if ((n & 4) != 0) {
            d3 = vector.z;
        }
        return vector.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Vector(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ')';
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)other;
        if (Double.compare(this.x, vector.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, vector.y) != 0) {
            return false;
        }
        return Double.compare(this.z, vector.z) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Ldev/jamesyox/kastro/util/Vector$Companion;", "", "()V", "ofPolar", "Ldev/jamesyox/kastro/util/Vector;", "phi", "", "theta", "r", "kastro"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector ofPolar(double phi, double theta, double r) {
            double cosTheta = Math.cos(theta);
            return new Vector(r * Math.cos(phi) * cosTheta, r * Math.sin(phi) * cosTheta, r * Math.sin(theta));
        }

        public static /* synthetic */ Vector ofPolar$default(Companion companion, double d, double d2, double d3, int n, Object object) {
            if ((n & 4) != 0) {
                d3 = 1.0;
            }
            return companion.ofPolar(d, d2, d3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

