/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.LocationKt;
import dev.jamesyox.kastro.util.Matrix;
import dev.jamesyox.kastro.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Ldev/jamesyox/kastro/util/Sol;", "", "()V", "SUN_DISTANCE", "", "SUN_MEAN_RADIUS", "angularRadius", "distance", "position", "Ldev/jamesyox/kastro/util/Vector;", "date", "Ldev/jamesyox/kastro/util/JulianDate;", "positionEquatorial", "positionHorizontal", "lat", "Ldev/jamesyox/kastro/util/Latitude;", "lng", "Ldev/jamesyox/kastro/util/Longitude;", "positionHorizontal-1Yd9cXA", "(Ldev/jamesyox/kastro/util/JulianDate;DD)Ldev/jamesyox/kastro/util/Vector;", "kastro"})
public final class Sol {
    @NotNull
    public static final Sol INSTANCE = new Sol();
    private static final double SUN_DISTANCE = 1.49598E8;
    private static final double SUN_MEAN_RADIUS = 695700.0;

    private Sol() {
    }

    @NotNull
    public final Vector positionEquatorial(@NotNull JulianDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double t = date.getJulianCentury$kastro();
        double m = Math.PI * 2 * ExtendedMath.INSTANCE.frac(0.993133 + 99.997361 * t);
        double l = Math.PI * 2 * ExtendedMath.INSTANCE.frac(0.7859453 + m / (Math.PI * 2) + (6893.0 * Math.sin(m) + 72.0 * Math.sin(2.0 * m) + 6191.2 * t) / 1296000.0);
        double d = 1.49598E8 * (1.0 - 0.016718 * Math.cos(JulianDateKt.getTrueAnomaly(date)));
        return Vector.Companion.ofPolar(l, 0.0, d);
    }

    @NotNull
    public final Vector position(@NotNull JulianDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Matrix rotateMatrix = ExtendedMath.INSTANCE.equatorialToEcliptical(date).transpose();
        return rotateMatrix.multiply(this.positionEquatorial(date));
    }

    @NotNull
    public final Vector positionHorizontal-1Yd9cXA(@NotNull JulianDate date, double lat, double lng) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Vector mc = this.position(date);
        double h = JulianDateKt.getGreenwichMeanSiderealTime(date) + LocationKt.getRadians-mSaymZU(lng) - mc.getPhi();
        return ExtendedMath.INSTANCE.equatorialToHorizontal-0GiciWk(h, mc.getTheta(), mc.getR(), lat);
    }

    public final double angularRadius(double distance) {
        return Math.asin(695700.0 / distance);
    }
}

