/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/jamesyox/kastro/util/Pegasus;", "", "()V", "MAX_ITERATIONS", "", "calculate", "", "lower", "upper", "accuracy", "f", "Lkotlin/Function1;", "kastro"})
public final class Pegasus {
    @NotNull
    public static final Pegasus INSTANCE = new Pegasus();
    private static final int MAX_ITERATIONS = 30;

    private Pegasus() {
    }

    public final double calculate(double lower, double upper, double accuracy, @NotNull Function1<? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        double x1 = lower;
        double x2 = upper;
        double f1 = ((Number)f.invoke((Object)x1)).doubleValue();
        double f2 = ((Number)f.invoke((Object)x2)).doubleValue();
        if (f1 * f2 >= 0.0) {
            throw new ArithmeticException("No root within the given boundaries");
        }
        int i = 30;
        while (i-- > 0) {
            double x3 = x2 - f2 / ((f2 - f1) / (x2 - x1));
            double f3 = ((Number)f.invoke((Object)x3)).doubleValue();
            if (f3 * f2 <= 0.0) {
                x1 = x2;
                f1 = f2;
                x2 = x3;
                f2 = f3;
            } else {
                f1 = f1 * f2 / (f2 + f3);
                x2 = x3;
                f2 = f3;
            }
            if (!(Math.abs(x2 - x1) <= accuracy)) continue;
            return Math.abs(f1) < Math.abs(f2) ? x1 : x2;
        }
        throw new ArithmeticException("Maximum number of iterations exceeded");
    }
}

