/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.LocationKt;
import dev.jamesyox.kastro.util.Matrix;
import dev.jamesyox.kastro.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0013"}, d2={"Ldev/jamesyox/kastro/util/Moon;", "", "()V", "MOON_MEAN_RADIUS", "", "angularRadius", "distance", "position", "Ldev/jamesyox/kastro/util/Vector;", "date", "Ldev/jamesyox/kastro/util/JulianDate;", "positionEquatorial", "positionHorizontal", "lat", "Ldev/jamesyox/kastro/util/Latitude;", "lng", "Ldev/jamesyox/kastro/util/Longitude;", "positionHorizontal-1Yd9cXA", "(Ldev/jamesyox/kastro/util/JulianDate;DD)Ldev/jamesyox/kastro/util/Vector;", "kastro"})
public final class Moon {
    @NotNull
    public static final Moon INSTANCE = new Moon();
    private static final double MOON_MEAN_RADIUS = 1737.1;

    private Moon() {
    }

    @NotNull
    public final Vector positionEquatorial(@NotNull JulianDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double t = date.getJulianCentury$kastro();
        double l0 = ExtendedMath.INSTANCE.frac(0.606433 + 1336.855225 * t);
        double l = Math.PI * 2 * ExtendedMath.INSTANCE.frac(0.374897 + 1325.55241 * t);
        double ls = Math.PI * 2 * ExtendedMath.INSTANCE.frac(0.993133 + 99.997361 * t);
        double d = Math.PI * 2 * ExtendedMath.INSTANCE.frac(0.827361 + 1236.853086 * t);
        double f = Math.PI * 2 * ExtendedMath.INSTANCE.frac(0.259086 + 1342.227825 * t);
        double d2 = 2.0 * d;
        double l2 = 2.0 * l;
        double f2 = 2.0 * f;
        double dL = 22640.0 * Math.sin(l) - 4586.0 * Math.sin(l - d2) + 2370.0 * Math.sin(d2) + 769.0 * Math.sin(l2) - 668.0 * Math.sin(ls) - 412.0 * Math.sin(f2) - 212.0 * Math.sin(l2 - d2) - 206.0 * Math.sin(l + ls - d2) + 192.0 * Math.sin(l + d2) - 165.0 * Math.sin(ls - d2) - 125.0 * Math.sin(d) - 110.0 * Math.sin(l + ls) + 148.0 * Math.sin(l - ls) - 55.0 * Math.sin(f2 - d2);
        double s = f + (dL + 412.0 * Math.sin(f2) + 541.0 * Math.sin(ls)) / ExtendedMath.INSTANCE.getARCS();
        double h = f - d2;
        double n = -526.0 * Math.sin(h) + 44.0 * Math.sin(l + h) - 31.0 * Math.sin(-l + h) - 23.0 * Math.sin(ls + h) + 11.0 * Math.sin(-ls + h) - 25.0 * Math.sin(-l2 + f) + 21.0 * Math.sin(-l + f);
        double lMoon = Math.PI * 2 * ExtendedMath.INSTANCE.frac(l0 + dL / 1296000.0);
        double bMoon = (18520.0 * Math.sin(s) + n) / ExtendedMath.INSTANCE.getARCS();
        double dt = 385000.5584 - 20905.355 * Math.cos(l) - 3699.1109 * Math.cos(d2 - l) - 2955.9676 * Math.cos(d2) - 569.9251 * Math.cos(l2);
        return Vector.Companion.ofPolar(lMoon, bMoon, dt);
    }

    @NotNull
    public final Vector position(@NotNull JulianDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Matrix rotateMatrix = ExtendedMath.INSTANCE.equatorialToEcliptical(date).transpose();
        return rotateMatrix.multiply(this.positionEquatorial(date));
    }

    @NotNull
    public final Vector positionHorizontal-1Yd9cXA(@NotNull JulianDate date, double lat, double lng) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Vector mc = this.position(date);
        double h = JulianDateKt.getGreenwichMeanSiderealTime(date) + LocationKt.getRadians-mSaymZU(lng) - mc.getPhi();
        return ExtendedMath.INSTANCE.equatorialToHorizontal-0GiciWk(h, mc.getTheta(), mc.getR(), lat);
    }

    public final double angularRadius(double distance) {
        return Math.asin(1737.1 / distance);
    }
}

