/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import dev.jamesyox.kastro.util.Vector;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0019\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0086\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J!\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0004H\u0082\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/jamesyox/kastro/util/Matrix;", "", "()V", "d1", "", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "(DDDDDDDDD)V", "mx", "", "equals", "", "other", "get", "r", "", "c", "hashCode", "minus", "right", "multiply", "Ldev/jamesyox/kastro/util/Vector;", "scalar", "negate", "plus", "set", "", "v", "toString", "", "transpose", "Companion", "kastro"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\ndev/jamesyox/kastro/util/Matrix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class Matrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] mx;

    public Matrix(double d1, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[] dArray = new double[]{d1, d2, d3, d4, d5, d6, d7, d8, d9};
        this.mx = dArray;
    }

    public Matrix() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final Matrix transpose() {
        Matrix result = new Matrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                result.set(i, j, this.get(j, i));
            }
        }
        return result;
    }

    @NotNull
    public final Matrix negate() {
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = -this.mx[i];
        }
        return result;
    }

    @NotNull
    public final Matrix plus(@NotNull Matrix right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = this.mx[i] + right.mx[i];
        }
        return result;
    }

    @NotNull
    public final Matrix minus(@NotNull Matrix right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = this.mx[i] - right.mx[i];
        }
        return result;
    }

    @NotNull
    public final Matrix multiply(@NotNull Matrix right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Matrix result = new Matrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double scalp = 0.0;
                for (int k = 0; k < 3; ++k) {
                    scalp += this.get(i, k) * right.get(k, j);
                }
                result.set(i, j, scalp);
            }
        }
        return result;
    }

    @NotNull
    public final Matrix multiply(double scalar) {
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = this.mx[i] * scalar;
        }
        return result;
    }

    @NotNull
    public final Vector multiply(@NotNull Vector right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        double[] dArray = new double[]{right.getX(), right.getY(), right.getZ()};
        double[] vec = dArray;
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            double scalp = 0.0;
            for (int j = 0; j < 3; ++j) {
                scalp += this.get(i, j) * vec[j];
            }
            result[i] = scalp;
        }
        return new Vector(result[0], result[1], result[2]);
    }

    public final double get(int r, int c) {
        if (!(r >= 0 && r <= 2 && c >= 0 && c <= 2)) {
            boolean bl = false;
            String string = "row/column out of range: " + r + ':' + c;
            throw new IllegalArgumentException(string.toString());
        }
        return this.mx[r * 3 + c];
    }

    private final void set(int r, int c, double v) {
        if (!(r >= 0 && r <= 2 && c >= 0 && c <= 2)) {
            boolean bl = false;
            String string = "row/column out of range: " + r + ':' + c;
            throw new IllegalArgumentException(string.toString());
        }
        this.mx[r * 3 + c] = v;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Matrix cfr_ignored_0 = (Matrix)other;
        return Arrays.equals(this.mx, ((Matrix)other).mx);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mx);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Matrix(mx=");
        String string = Arrays.toString(this.mx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).append(')').toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Ldev/jamesyox/kastro/util/Matrix$Companion;", "", "()V", "identity", "Ldev/jamesyox/kastro/util/Matrix;", "rotateX", "angle", "", "rotateY", "rotateZ", "kastro"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix identity() {
            return new Matrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix rotateX(double angle) {
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            return new Matrix(1.0, 0.0, 0.0, 0.0, c, s, 0.0, -s, c);
        }

        @NotNull
        public final Matrix rotateY(double angle) {
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            return new Matrix(c, 0.0, -s, 0.0, 1.0, 0.0, s, 0.0, c);
        }

        @NotNull
        public final Matrix rotateZ(double angle) {
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            return new Matrix(c, s, 0.0, -s, c, 0.0, 0.0, 0.0, 1.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

