/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\u00020\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0004*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0012"}, d2={"daysInJulianCentury", "", "secondsInDay", "greenwichMeanSiderealTime", "Ldev/jamesyox/kastro/util/JulianDate;", "getGreenwichMeanSiderealTime", "(Ldev/jamesyox/kastro/util/JulianDate;)D", "instant", "Lkotlinx/datetime/Instant;", "getInstant", "(Ldev/jamesyox/kastro/util/JulianDate;)Lkotlinx/datetime/Instant;", "julianDate", "getJulianDate", "(Lkotlinx/datetime/Instant;)Ldev/jamesyox/kastro/util/JulianDate;", "trueAnomaly", "getTrueAnomaly", "atJulianCentury", "jc", "kastro"})
public final class JulianDateKt {
    public static final double daysInJulianCentury = 36525.0;
    private static final double secondsInDay = 86400.0;

    @NotNull
    public static final JulianDate getJulianDate(@NotNull Instant $this$julianDate) {
        Intrinsics.checkNotNullParameter((Object)$this$julianDate, (String)"<this>");
        return new JulianDate((double)$this$julianDate.toEpochMilliseconds() / 8.64E7 + JulianDate.Companion.getJ1970$kastro().getValue$kastro());
    }

    @NotNull
    public static final Instant getInstant(@NotNull JulianDate $this$instant) {
        Intrinsics.checkNotNullParameter((Object)$this$instant, (String)"<this>");
        return Instant.Companion.fromEpochMilliseconds(MathKt.roundToLong((double)(($this$instant.getValue$kastro() - JulianDate.Companion.getJ1970$kastro().getValue$kastro()) * 8.64E7)));
    }

    @NotNull
    public static final JulianDate atJulianCentury(double jc) {
        return new JulianDate(jc * 36525.0 + JulianDate.Companion.getJ2000$kastro().getValue$kastro());
    }

    public static final double getGreenwichMeanSiderealTime(@NotNull JulianDate $this$greenwichMeanSiderealTime) {
        Intrinsics.checkNotNullParameter((Object)$this$greenwichMeanSiderealTime, (String)"<this>");
        double ut = ($this$greenwichMeanSiderealTime.getMjd$kastro() - $this$greenwichMeanSiderealTime.getTmjd$kastro()) * 86400.0;
        double t0 = ($this$greenwichMeanSiderealTime.getTmjd$kastro() - JulianDate.Companion.getJ2000$kastro().getMjd$kastro()) / 36525.0;
        double t = ($this$greenwichMeanSiderealTime.getMjd$kastro() - JulianDate.Companion.getJ2000$kastro().getMjd$kastro()) / 36525.0;
        double gmst = 24110.54841 + 8640184.812866 * t0 + 1.0027379093 * ut + (0.093104 - 6.2E-6 * t) * t * t;
        return 7.27220521664304E-5 * (gmst % 86400.0);
    }

    public static final double getTrueAnomaly(@NotNull JulianDate $this$trueAnomaly) {
        Intrinsics.checkNotNullParameter((Object)$this$trueAnomaly, (String)"<this>");
        int dayOfYear = TimeZoneKt.toLocalDateTime((Instant)JulianDateKt.getInstant($this$trueAnomaly), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDayOfYear();
        return Math.PI * 2 * ExtendedMath.INSTANCE.frac(((double)dayOfYear - 5.0) / 365.256363);
    }
}

