/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.util;

import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.KUtilsKt;
import dev.jamesyox.kastro.util.LocationKt;
import dev.jamesyox.kastro.util.Matrix;
import dev.jamesyox.kastro.util.Vector;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J]\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040+2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u00040-j\b\u0012\u0004\u0012\u00020\u0004`.H\u0082\u0010J2\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040+J2\u00102\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040+J\u000e\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00065"}, d2={"Ldev/jamesyox/kastro/util/ExtendedMath;", "", "()V", "ARCS", "", "getARCS", "()D", "EARTH_MEAN_RADIUS", "PI2", "apparentRefraction", "ha", "dms", "d", "", "m", "s", "equatorialToEcliptical", "Ldev/jamesyox/kastro/util/Matrix;", "t", "Ldev/jamesyox/kastro/util/JulianDate;", "equatorialToHorizontal", "Ldev/jamesyox/kastro/util/Vector;", "tau", "dec", "dist", "lat", "Ldev/jamesyox/kastro/util/Latitude;", "equatorialToHorizontal-0GiciWk", "(DDDD)Ldev/jamesyox/kastro/util/Vector;", "frac", "a", "isZero", "", "parallax", "height", "distance", "readjustInterval", "left", "right", "yl", "yr", "depth", "f", "Lkotlin/Function1;", "cmp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "readjustMax", "time", "frame", "readjustMin", "refraction", "h", "kastro"})
public final class ExtendedMath {
    @NotNull
    public static final ExtendedMath INSTANCE = new ExtendedMath();
    public static final double PI2 = Math.PI * 2;
    private static final double ARCS = KUtilsKt.getDegrees(3600.0);
    private static final double EARTH_MEAN_RADIUS = 6371.0;

    private ExtendedMath() {
    }

    public final double getARCS() {
        return ARCS;
    }

    public final double frac(double a) {
        return a % 1.0;
    }

    public final boolean isZero(double d) {
        return !Double.isNaN(d) && MathKt.roundToLong((double)Math.signum(d)) == 0L;
    }

    @NotNull
    public final Vector equatorialToHorizontal-0GiciWk(double tau, double dec, double dist, double lat) {
        return Matrix.Companion.rotateY(1.5707963267948966 - LocationKt.getRadians-zLPoVEA(lat)).multiply(Vector.Companion.ofPolar(tau, dec, dist));
    }

    @NotNull
    public final Matrix equatorialToEcliptical(@NotNull JulianDate t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        double jc = t.getJulianCentury$kastro();
        double eps = KUtilsKt.getRadians(23.43929111 - (46.815 + (5.9E-4 - 0.001813 * jc) * jc) * jc / 3600.0);
        return Matrix.Companion.rotateX(eps);
    }

    public final double parallax(double height, double distance) {
        return Math.asin(6371.0 / distance) - Math.acos(6371.0 / (6371.0 + height / 1000.0));
    }

    public final double apparentRefraction(double ha) {
        return ha < 0.0 ? 0.0 : Math.PI / (Math.tan(KUtilsKt.getRadians(ha + 7.31 / (ha + 4.4))) * 10800.0);
    }

    public final double refraction(double h) {
        return h < 0.0 ? 0.0 : 2.96706E-4 / Math.tan(h + 0.00312537 / (h + 0.0890118));
    }

    public final double dms(int d, int m, double s) {
        double sig = d < 0 ? -1.0 : 1.0;
        return sig * ((Math.abs(s) / 60.0 + (double)Math.abs(m)) / 60.0 + (double)Math.abs(d));
    }

    public final double readjustMax(double time, double frame, int depth, @NotNull Function1<? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        double left = time - frame;
        double right = time + frame;
        double leftY = ((Number)f.invoke((Object)left)).doubleValue();
        double rightY = ((Number)f.invoke((Object)right)).doubleValue();
        return this.readjustInterval(left, right, leftY, rightY, depth, f, ExtendedMath::readjustMax$lambda$0);
    }

    public final double readjustMin(double time, double frame, int depth, @NotNull Function1<? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        double left = time - frame;
        double right = time + frame;
        double leftY = ((Number)f.invoke((Object)left)).doubleValue();
        double rightY = ((Number)f.invoke((Object)right)).doubleValue();
        return this.readjustInterval(left, right, leftY, rightY, depth, f, ExtendedMath::readjustMin$lambda$1);
    }

    private final double readjustInterval(double left, double right, double yl, double yr, int depth, Function1<? super Double, Double> f, Comparator<Double> cmp) {
        while (depth > 0) {
            ExtendedMath this_;
            Comparator<Double> comparator;
            Function1<? super Double, Double> function1;
            int n;
            double d;
            double d2;
            ExtendedMath extendedMath;
            double middle = (left + right) / 2.0;
            double ym = ((Number)f.invoke((Object)middle)).doubleValue();
            if (cmp.compare(yl, yr) < 0) {
                extendedMath = this_;
                d2 = right;
                d = yr;
                n = depth - 1;
                function1 = f;
                comparator = cmp;
                this_ = extendedMath;
                left = middle;
                right = d2;
                yl = ym;
                yr = d;
                depth = n;
                f = function1;
                cmp = comparator;
                continue;
            }
            extendedMath = this_;
            d2 = left;
            d = yl;
            n = depth - 1;
            function1 = f;
            comparator = cmp;
            this_ = extendedMath;
            left = d2;
            right = middle;
            yl = d;
            yr = ym;
            depth = n;
            f = function1;
            cmp = comparator;
        }
        return cmp.compare(yl, yr) < 0 ? right : left;
    }

    private static final int readjustMax$lambda$0(Double d1, Double d2) {
        double d = d1;
        Intrinsics.checkNotNull((Object)d2);
        return Double.compare(d, d2);
    }

    private static final int readjustMin$lambda$1(Double yl, Double yr) {
        double d = yr;
        Intrinsics.checkNotNull((Object)yl);
        return Double.compare(d, yl);
    }
}

