/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.sol;

import dev.jamesyox.kastro.common.HorizonMovementState;
import dev.jamesyox.kastro.common.HorizonMovementStateKt;
import dev.jamesyox.kastro.common.HorizonState;
import dev.jamesyox.kastro.sol.LightPhase;
import dev.jamesyox.kastro.sol.LightPhaseInfo;
import dev.jamesyox.kastro.sol.LightState;
import dev.jamesyox.kastro.sol.LightStateKt;
import dev.jamesyox.kastro.sol.SolarPhase;
import dev.jamesyox.kastro.sol.Twilight;
import dev.jamesyox.kastro.sol.TwilightInfoKt;
import dev.jamesyox.kastro.util.KUtilsKt;
import dev.jamesyox.kastro.util.Moon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000bR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000b\u00a8\u00062"}, d2={"Ldev/jamesyox/kastro/sol/SolarState;", "", "azimuth", "", "distance", "atmosphericRefractionRad", "trueAltitudeRad", "parallaxRad", "(DDDDD)V", "altitude", "getAltitude", "()D", "atmosphericRefraction", "getAtmosphericRefraction", "getAtmosphericRefractionRad$kastro", "getAzimuth", "getDistance", "horizonMovementState", "Ldev/jamesyox/kastro/common/HorizonMovementState;", "getHorizonMovementState", "()Ldev/jamesyox/kastro/common/HorizonMovementState;", "horizonState", "Ldev/jamesyox/kastro/common/HorizonState;", "getHorizonState", "()Ldev/jamesyox/kastro/common/HorizonState;", "lightStates", "", "Ldev/jamesyox/kastro/sol/LightState;", "getLightStates", "()Ljava/util/List;", "parallax", "getParallax", "getParallaxRad$kastro", "solarPhase", "Ldev/jamesyox/kastro/sol/SolarPhase;", "getSolarPhase", "()Ldev/jamesyox/kastro/sol/SolarPhase;", "trueAltitude", "getTrueAltitude", "getTrueAltitudeRad$kastro", "altitudeAt", "angularPosition", "angularPositionOffset", "equals", "", "other", "hashCode", "", "toString", "", "kastro"})
@SourceDebugExtension(value={"SMAP\nSolarState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarState.kt\ndev/jamesyox/kastro/sol/SolarState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n766#2:188\n857#2,2:189\n1549#2:191\n1620#2,3:192\n*S KotlinDebug\n*F\n+ 1 SolarState.kt\ndev/jamesyox/kastro/sol/SolarState\n*L\n114#1:188\n114#1:189,2\n115#1:191\n115#1:192,3\n*E\n"})
public final class SolarState {
    private final double azimuth;
    private final double distance;
    private final double atmosphericRefractionRad;
    private final double trueAltitudeRad;
    private final double parallaxRad;
    private final double atmosphericRefraction;
    private final double trueAltitude;
    private final double parallax;
    private final double altitude;
    @NotNull
    private final HorizonMovementState horizonMovementState;
    @NotNull
    private final List<LightState> lightStates;
    @NotNull
    private final SolarPhase solarPhase;

    /*
     * WARNING - void declaration
     */
    public SolarState(double azimuth, double distance, double atmosphericRefractionRad, double trueAltitudeRad, double parallaxRad) {
        SolarPhase solarPhase;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LightPhaseInfo it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        this.azimuth = azimuth;
        this.distance = distance;
        this.atmosphericRefractionRad = atmosphericRefractionRad;
        this.trueAltitudeRad = trueAltitudeRad;
        this.parallaxRad = parallaxRad;
        this.atmosphericRefraction = KUtilsKt.getDegrees(this.atmosphericRefractionRad);
        this.trueAltitude = KUtilsKt.getDegrees(this.trueAltitudeRad);
        this.parallax = KUtilsKt.getDegrees(this.parallaxRad);
        this.altitude = this.trueAltitude + (this.atmosphericRefraction - this.parallax);
        this.horizonMovementState = HorizonMovementStateKt.fromAzimuth(this.azimuth);
        Iterable iterable = LightPhaseInfo.Companion.getAll();
        SolarState solarState = this;
        boolean $i$f$filter = false;
        void var13_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LightPhaseInfo)element$iv$iv;
            boolean bl = false;
            if (!LightStateKt.getAngleRange(it).contains((Comparable)Double.valueOf(this.trueAltitude))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LightState lightState;
            it = (LightPhaseInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LightPhaseInfo lightPhaseInfo = it;
            if (Intrinsics.areEqual((Object)lightPhaseInfo, (Object)LightPhase.GoldenHour.Companion)) {
                LightPhase lightPhase;
                switch (WhenMappings.$EnumSwitchMapping$0[this.horizonMovementState.ordinal()]) {
                    case 1: {
                        lightPhase = LightState.GoldenHourDawn.INSTANCE;
                        break;
                    }
                    case 2: {
                        lightPhase = LightState.GoldenHourDusk.INSTANCE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                lightState = (LightState)lightPhase;
            } else if (Intrinsics.areEqual((Object)lightPhaseInfo, (Object)LightPhase.BlueHour.Companion)) {
                LightPhase lightPhase;
                switch (WhenMappings.$EnumSwitchMapping$0[this.horizonMovementState.ordinal()]) {
                    case 1: {
                        lightPhase = LightState.BlueHourDawn.INSTANCE;
                        break;
                    }
                    case 2: {
                        lightPhase = LightState.BlueHourDusk.INSTANCE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                lightState = (LightState)lightPhase;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(lightState);
        }
        solarState.lightStates = (List)destination$iv$iv;
        if (TwilightInfoKt.getAngleRange(Twilight.CivilTwilight.Companion).contains((Comparable)Double.valueOf(this.trueAltitude))) {
            SolarPhase solarPhase2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.horizonMovementState.ordinal()]) {
                case 1: {
                    solarPhase2 = SolarPhase.CivilDawn.INSTANCE;
                    break;
                }
                case 2: {
                    solarPhase2 = SolarPhase.CivilDusk.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            solarPhase = solarPhase2;
        } else if (TwilightInfoKt.getAngleRange(Twilight.NauticalTwilight.Companion).contains((Comparable)Double.valueOf(this.trueAltitude))) {
            SolarPhase solarPhase3;
            switch (WhenMappings.$EnumSwitchMapping$0[this.horizonMovementState.ordinal()]) {
                case 1: {
                    solarPhase3 = SolarPhase.NauticalDawn.INSTANCE;
                    break;
                }
                case 2: {
                    solarPhase3 = SolarPhase.NauticalDusk.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            solarPhase = solarPhase3;
        } else if (TwilightInfoKt.getAngleRange(Twilight.AstronomicalTwilight.Companion).contains((Comparable)Double.valueOf(this.trueAltitude))) {
            SolarPhase solarPhase4;
            switch (WhenMappings.$EnumSwitchMapping$0[this.horizonMovementState.ordinal()]) {
                case 1: {
                    solarPhase4 = SolarPhase.AstronomicalDawn.INSTANCE;
                    break;
                }
                case 2: {
                    solarPhase4 = SolarPhase.AstronomicalDusk.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            solarPhase = solarPhase4;
        } else {
            solarPhase = this.trueAltitude > 0.0 ? (SolarPhase)SolarPhase.Day.INSTANCE : (SolarPhase)SolarPhase.Night.INSTANCE;
        }
        this.solarPhase = solarPhase;
    }

    public final double getAzimuth() {
        return this.azimuth;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final double getAtmosphericRefractionRad$kastro() {
        return this.atmosphericRefractionRad;
    }

    public final double getTrueAltitudeRad$kastro() {
        return this.trueAltitudeRad;
    }

    public final double getParallaxRad$kastro() {
        return this.parallaxRad;
    }

    public final double getAtmosphericRefraction() {
        return this.atmosphericRefraction;
    }

    public final double getTrueAltitude() {
        return this.trueAltitude;
    }

    public final double getParallax() {
        return this.parallax;
    }

    public final double getAltitude() {
        return this.altitude;
    }

    private final double angularPositionOffset(double angularPosition) {
        return angularPosition * Moon.INSTANCE.angularRadius(this.distance);
    }

    public final double altitudeAt(double angularPosition) {
        return this.altitude + this.angularPositionOffset(angularPosition);
    }

    @NotNull
    public final HorizonState getHorizonState() {
        HorizonState horizonState;
        boolean bl;
        boolean bl2 = bl = this.altitudeAt(1.0) > 0.0;
        if (bl) {
            horizonState = HorizonState.Up;
        } else if (!bl) {
            horizonState = HorizonState.Down;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return horizonState;
    }

    @NotNull
    public final HorizonMovementState getHorizonMovementState() {
        return this.horizonMovementState;
    }

    @NotNull
    public final List<LightState> getLightStates() {
        return this.lightStates;
    }

    @NotNull
    public final SolarPhase getSolarPhase() {
        return this.solarPhase;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SolarState cfr_ignored_0 = (SolarState)other;
        if (!(this.azimuth == ((SolarState)other).azimuth)) {
            return false;
        }
        if (!(this.distance == ((SolarState)other).distance)) {
            return false;
        }
        if (!(this.atmosphericRefractionRad == ((SolarState)other).atmosphericRefractionRad)) {
            return false;
        }
        if (!(this.trueAltitudeRad == ((SolarState)other).trueAltitudeRad)) {
            return false;
        }
        return this.parallaxRad == ((SolarState)other).parallaxRad;
    }

    public int hashCode() {
        int result = Double.hashCode(this.azimuth);
        result = 31 * result + Double.hashCode(this.distance);
        result = 31 * result + Double.hashCode(this.atmosphericRefractionRad);
        result = 31 * result + Double.hashCode(this.trueAltitudeRad);
        result = 31 * result + Double.hashCode(this.parallaxRad);
        return result;
    }

    @NotNull
    public String toString() {
        return "SunState(azimuth=" + this.azimuth + ", distance=" + this.distance + ", atmosphericRefraction=" + this.atmosphericRefraction + ", trueAltitude=" + this.trueAltitude + ", parallax=" + this.parallax + ", altitude=" + this.altitude + ", horizonState=" + (Object)((Object)this.getHorizonState()) + ", solarPhase=" + this.solarPhase + ", lightStates=" + this.lightStates + ", horizonMovementState=" + (Object)((Object)this.horizonMovementState) + ')';
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HorizonMovementState.values().length];
            try {
                nArray[HorizonMovementState.Rising.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizonMovementState.Setting.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

