/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.sol;

import dev.jamesyox.kastro.sol.CalculateSolarStateKt;
import dev.jamesyox.kastro.sol.SolarEvent;
import dev.jamesyox.kastro.sol.SolarEventType;
import dev.jamesyox.kastro.sol.SolarEventTypeKt;
import dev.jamesyox.kastro.sol.SolarState;
import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.KUtilsKt;
import dev.jamesyox.kastro.util.QuadraticInterpolation;
import dev.jamesyox.kastro.util.Sol;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010(\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0096\u0002R\u0016\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\t\u001a\u00020\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006#"}, d2={"Ldev/jamesyox/kastro/sol/SolarAngleEventSequence;", "Lkotlin/sequences/Sequence;", "Ldev/jamesyox/kastro/sol/SolarEvent;", "start", "Lkotlinx/datetime/Instant;", "latitude", "Ldev/jamesyox/kastro/util/Latitude;", "longitude", "Ldev/jamesyox/kastro/util/Longitude;", "limit", "Lkotlin/time/Duration;", "requestedAngleEvents", "", "Ldev/jamesyox/kastro/sol/SolarEventType$Angle;", "(Lkotlinx/datetime/Instant;DDJLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "chunkTime", "J", "D", "limitTime", "calculateNextSolarAngleEvent", "localStart", "angle", "height", "", "localLimit", "calculateNextSolarAngleEvent-Wn2Vu4Y", "(Lkotlinx/datetime/Instant;Ldev/jamesyox/kastro/sol/SolarEventType$Angle;DJ)Ldev/jamesyox/kastro/sol/SolarEvent;", "calculateNextSolarEvents", "calculateNextSolarEvents-HG0u8IE", "(Lkotlinx/datetime/Instant;J)Lkotlin/sequences/Sequence;", "getLocalLimit", "getLocalLimit-5sfh64U", "(Lkotlinx/datetime/Instant;)J", "iterator", "", "kastro"})
@SourceDebugExtension(value={"SMAP\nSolarAngleEventSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarAngleEventSequence.kt\ndev/jamesyox/kastro/sol/SolarAngleEventSequence\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,156:1\n603#2:157\n*S KotlinDebug\n*F\n+ 1 SolarAngleEventSequence.kt\ndev/jamesyox/kastro/sol/SolarAngleEventSequence\n*L\n76#1:157\n*E\n"})
public final class SolarAngleEventSequence
implements Sequence<SolarEvent> {
    @NotNull
    private final Instant start;
    private final double latitude;
    private final double longitude;
    private final long limit;
    @NotNull
    private final List<SolarEventType.Angle> requestedAngleEvents;
    @NotNull
    private final Instant limitTime;
    private final long chunkTime;

    private SolarAngleEventSequence(Instant start, double latitude, double longitude, long limit, List<? extends SolarEventType.Angle> requestedAngleEvents) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(requestedAngleEvents, (String)"requestedAngleEvents");
        this.start = start;
        this.latitude = latitude;
        this.longitude = longitude;
        this.limit = limit;
        this.requestedAngleEvents = requestedAngleEvents;
        this.limitTime = this.start.plus-LRDsOJo(this.limit);
        this.chunkTime = DurationKt.toDuration((int)24, (DurationUnit)DurationUnit.HOURS);
    }

    private final long getLocalLimit-5sfh64U(Instant start) {
        return start.plus-LRDsOJo(this.chunkTime).compareTo(this.limitTime) < 0 ? this.chunkTime : this.limitTime.minus-5sfh64U(start);
    }

    @NotNull
    public Iterator<SolarEvent> iterator() {
        Ref.ObjectRef currentTime = new Ref.ObjectRef();
        currentTime.element = this.start;
        return SequencesKt.flatten((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Sequence<? extends SolarEvent>>((Ref.ObjectRef<Instant>)currentTime, this){
            final /* synthetic */ Ref.ObjectRef<Instant> $currentTime;
            final /* synthetic */ SolarAngleEventSequence this$0;
            {
                this.$currentTime = $currentTime;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Sequence<SolarEvent> invoke() {
                Sequence sequence = ((Instant)this.$currentTime.element).compareTo(SolarAngleEventSequence.access$getStart$p(this.this$0).plus-LRDsOJo(SolarAngleEventSequence.access$getLimit$p(this.this$0))) <= 0 ? SolarAngleEventSequence.access$calculateNextSolarEvents-HG0u8IE(this.this$0, (Instant)this.$currentTime.element, SolarAngleEventSequence.access$getLocalLimit-5sfh64U(this.this$0, (Instant)this.$currentTime.element)) : null;
                Ref.ObjectRef<Instant> objectRef = this.$currentTime;
                SolarAngleEventSequence solarAngleEventSequence = this.this$0;
                Sequence it = sequence;
                boolean bl = false;
                objectRef.element = ((Instant)objectRef.element).plus-LRDsOJo(Duration.plus-LRDsOJo((long)SolarAngleEventSequence.access$getChunkTime$p(solarAngleEventSequence), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)));
                return sequence;
            }
        }))).iterator();
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<SolarEvent> calculateNextSolarEvents-HG0u8IE(Instant localStart, long localLimit) {
        void $this$sortedBy$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.requestedAngleEvents), (Function1)((Function1)new Function1<SolarEventType.Angle, SolarEvent>(this, localStart, localLimit){
            final /* synthetic */ SolarAngleEventSequence this$0;
            final /* synthetic */ Instant $localStart;
            final /* synthetic */ long $localLimit;
            {
                this.this$0 = $receiver;
                this.$localStart = $localStart;
                this.$localLimit = $localLimit;
                super(1);
            }

            @Nullable
            public final SolarEvent invoke(@NotNull SolarEventType.Angle angle) {
                Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
                return SolarAngleEventSequence.access$calculateNextSolarAngleEvent-Wn2Vu4Y(this.this$0, this.$localStart, angle, 0.0, this.$localLimit);
            }
        }));
        boolean $i$f$sortedBy = false;
        return SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SolarEvent it = (SolarEvent)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getTime();
                it = (SolarEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTime()));
            }
        });
    }

    private final SolarEvent calculateNextSolarAngleEvent-Wn2Vu4Y(Instant localStart, SolarEventType.Angle angle, double height, long localLimit) {
        JulianDate julianDate = JulianDateKt.getJulianDate(localStart);
        int hour = 0;
        double limitHours = (double)Duration.getInWholeMilliseconds-impl((long)localLimit) / (double)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS));
        int maxHours = (int)Math.ceil(limitHours);
        double yMinus = SolarAngleEventSequence.calculateNextSolarAngleEvent_Wn2Vu4Y$correctedSunHeight(angle, this, height, julianDate.atHour((double)hour - 1.0));
        double y0 = SolarAngleEventSequence.calculateNextSolarAngleEvent_Wn2Vu4Y$correctedSunHeight(angle, this, height, julianDate.atHour(hour));
        double yPlus = SolarAngleEventSequence.calculateNextSolarAngleEvent_Wn2Vu4Y$correctedSunHeight(angle, this, height, julianDate.atHour((double)hour + 1.0));
        while (hour <= maxHours) {
            QuadraticInterpolation qi = QuadraticInterpolation.Companion.of(yMinus, y0, yPlus);
            double ye = qi.getYe();
            if (qi.getNumberOfRoots() == 1) {
                double rt = qi.getRoot1() + (double)hour;
                if (yMinus < 0.0 ? angle instanceof SolarEventType.Angle.Dawn && rt >= 0.0 && rt < limitHours : angle instanceof SolarEventType.Angle.Dusk && rt >= 0.0 && rt < limitHours) {
                    return SolarEventTypeKt.eventAt(angle, JulianDateKt.getInstant(julianDate.atHour(rt)));
                }
            } else if (qi.getNumberOfRoots() == 2) {
                double rt = (double)hour + (ye < 0.0 ? qi.getRoot2() : qi.getRoot1());
                boolean bl = false;
                if (angle instanceof SolarEventType.Angle.Dawn && rt >= 0.0 && rt < limitHours) {
                    return SolarEventTypeKt.eventAt(angle, JulianDateKt.getInstant(julianDate.atHour(rt)));
                }
                rt = (double)hour + (ye < 0.0 ? qi.getRoot1() : qi.getRoot2());
                boolean bl2 = false;
                if (angle instanceof SolarEventType.Angle.Dusk && rt >= 0.0 && rt < limitHours) {
                    return SolarEventTypeKt.eventAt(angle, JulianDateKt.getInstant(julianDate.atHour(rt)));
                }
            }
            yMinus = y0;
            y0 = yPlus;
            yPlus = SolarAngleEventSequence.calculateNextSolarAngleEvent_Wn2Vu4Y$correctedSunHeight(angle, this, height, julianDate.atHour((double)(++hour) + 1.0));
        }
        return null;
    }

    private static final double calculateNextSolarAngleEvent_Wn2Vu4Y$correctedSunHeight(SolarEventType.Angle $angle, SolarAngleEventSequence this$0, double $height, JulianDate jd) {
        double d;
        SolarState sunPos = $angle instanceof SolarEventType.TopocentricAngle ? CalculateSolarStateKt.calculateSolarState-sNAg2yY(jd, this$0.latitude, this$0.longitude, $height) : CalculateSolarStateKt.calculateSolarState-sNAg2yY(jd, this$0.latitude, this$0.longitude, $height);
        double angleRad = KUtilsKt.getRadians($angle.getAngle());
        if ($angle instanceof SolarEventType.TopocentricAngle) {
            double angularPositionRad = ((SolarEventType.TopocentricAngle)$angle).getAngularPosition() * Sol.INSTANCE.angularRadius(sunPos.getDistance());
            d = sunPos.getParallaxRad$kastro() - angularPositionRad - ExtendedMath.INSTANCE.apparentRefraction(angleRad);
        } else {
            d = 0.0;
        }
        double angleModifier = d;
        return sunPos.getTrueAltitudeRad$kastro() - (angleRad + angleModifier);
    }

    public /* synthetic */ SolarAngleEventSequence(Instant start, double latitude, double longitude, long limit, List requestedAngleEvents, DefaultConstructorMarker $constructor_marker) {
        this(start, latitude, longitude, limit, requestedAngleEvents);
    }

    public static final /* synthetic */ Instant access$getStart$p(SolarAngleEventSequence $this) {
        return $this.start;
    }

    public static final /* synthetic */ long access$getLimit$p(SolarAngleEventSequence $this) {
        return $this.limit;
    }

    public static final /* synthetic */ Sequence access$calculateNextSolarEvents-HG0u8IE(SolarAngleEventSequence $this, Instant localStart, long localLimit) {
        return $this.calculateNextSolarEvents-HG0u8IE(localStart, localLimit);
    }

    public static final /* synthetic */ long access$getLocalLimit-5sfh64U(SolarAngleEventSequence $this, Instant start) {
        return $this.getLocalLimit-5sfh64U(start);
    }

    public static final /* synthetic */ long access$getChunkTime$p(SolarAngleEventSequence $this) {
        return $this.chunkTime;
    }

    public static final /* synthetic */ SolarEvent access$calculateNextSolarAngleEvent-Wn2Vu4Y(SolarAngleEventSequence $this, Instant localStart, SolarEventType.Angle angle, double height, long localLimit) {
        return $this.calculateNextSolarAngleEvent-Wn2Vu4Y(localStart, angle, height, localLimit);
    }
}

